/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "RASTableView.h"

static NSColor			*sStripeColor = nil;

@implementation RASTableView

/* workaround for tablecolumn bug, which always draws its cells' backgrounds */
- ( void )awakeFromNib
{
    NSArray			*columns = [ self tableColumns ];
    id				cell = nil;
    int				i;
    
    _drawsStripes = NO;
    _umTableViewDragColumn = -1;
    
    for ( i = 0; i < [ columns count ]; i++ ) {
        cell = [[ columns objectAtIndex: i ] dataCell ];
        
        if ( [ cell isKindOfClass: [ NSTextFieldCell class ]] ) {
            [ cell setDrawsBackground: NO ];
            //[ cell setEditable: YES ];
            [ cell setFont: [ NSFont systemFontOfSize: 12.0 ]];
        }
        
        //cell = nil;
    }
}

- ( void )dragImage: ( NSImage * )anImage at: ( NSPoint )imageLoc offset: ( NSSize )mouseOffset
        event: ( NSEvent * )theEvent pasteboard: ( NSPasteboard * )pboard source: ( id )sourceObject
        slideBack: ( BOOL )slideBack
{
    int                 row = [ self rowAtPoint: imageLoc ];
    int                 column;
    NSRect		imageframe;
    float		width;
    float		height;
    NSSize		imagesize;
    NSImage		*image;
    NSView		*view;
  
    /* make sure the drag image is no larger than the viewable area */
    if (( view = [[ self superview ] superview ] ) == nil ) {
	view = self;
    }
    
    if (( column = [ self dragColumn ] ) >= 0 ) {
	imageframe = [ self frameOfCellAtColumn: column row: row ];
	width = NSWidth( imageframe );
    } else {
	width = NSWidth( [ self frame ] );
    }
    
    height = NSHeight( [ view frame ] );
    imagesize = NSMakeSize( width, height );
    image = [[ NSImage alloc ] initWithSize: imagesize ];
    
    /* only draw the portion from the filename column */
    [ image lockFocus ];
    [ anImage dissolveToPoint: NSZeroPoint fraction: 1.0 ];
    [ image unlockFocus ];

    [ super dragImage: image at: imageLoc offset: mouseOffset
            event: theEvent pasteboard: pboard source: sourceObject
            slideBack: slideBack ];
    [ image release ];
}

- ( int )dragColumn
{
    return( _umTableViewDragColumn );
}

- ( void )setDragColumn: ( int )column
{
    _umTableViewDragColumn = column;
}

- ( BOOL )drawsStripes
{
    return( _drawsStripes );
}

- ( void )setDrawsStripes: ( BOOL )stripes
{
    _drawsStripes = stripes;
}

/* stripe table rows. gleaned from code posted to cocoadev.com */
- ( void )drawStripesInRect: ( NSRect )rect
{
    NSRect			stripeRect;
    float			fullRowHeight = ( [ self rowHeight] + [ self intercellSpacing ].height );
    float 			clipBottom = NSMaxY( rect );
    int 			firstStripe = ( rect.origin.y / fullRowHeight );
    
    if (( firstStripe % 2 ) != 0 ) {
        firstStripe++;
    }
        
    stripeRect.origin.x = rect.origin.x;
    stripeRect.origin.y = ( firstStripe * fullRowHeight );
    stripeRect.size.width = rect.size.width;
    stripeRect.size.height = fullRowHeight;

    if ( sStripeColor == nil ) {
        sStripeColor = [[ NSColor colorWithCalibratedRed: ( 235.0 / 255.0 )
                           green: ( 254.0 / 255.0 )
                           blue: ( 225.0 / 255.0 )
                           alpha: 1.0 ] retain ];
    }
    
    [ sStripeColor set ];

    while ( stripeRect.origin.y < clipBottom ) {
        NSRectFill( stripeRect );
        stripeRect.origin.y += ( fullRowHeight * 2.0 );
    }
}

- ( void )highlightSelectionInClipRect: ( NSRect )rect
{
    BOOL	draws = [ self drawsStripes ];

    if ( draws == YES ) {
        [ self drawStripesInRect: rect ];
    }
    
    [ super highlightSelectionInClipRect: rect ];
}

- ( NSMenu * )menuForEvent: ( NSEvent * )event
{
    NSPoint	p = [ self convertPoint: [ event locationInWindow ]
                            fromView: nil ];
    int		column = [ self columnAtPoint: p ];
    int		row = [ self rowAtPoint: p ];
    
    rClickedRow = 0;
    
    if ( column == 0 && row >= 0  &&
        [[ self delegate ] respondsToSelector:
                @selector( menuForTable: tableColumn: row: ) ] ) {
        rClickedRow = row;
        [ self selectRow: row byExtendingSelection: NO ];
        [[ self window ] makeFirstResponder: self ];
        return( [[ self delegate ] menuForTable: self
                                    tableColumn: column
                                    row: row ] );
    }
    return( nil );
}

- ( int )rClickedRow
{
    return( rClickedRow );
}

- ( void )keyDown: ( NSEvent * )event
{
    if ( [[ self delegate ] respondsToSelector: @selector( handleKeyEvent:fromTable: ) ] ) {
        if ( [[ self delegate ] handleKeyEvent: event fromTable: self ] ) {
            return;
        }
    }
    
    [ super keyDown: event ];
}

- ( void )textDidEndEditing: ( NSNotification * )aNotification
{
    int			tm = [[[ aNotification userInfo ] objectForKey: @"NSTextMovement" ] intValue ];
    
    if ( tm == NSReturnTextMovement || tm == NSTabTextMovement ) {
        if ( [[ self dataSource ] respondsToSelector: @selector( handleChangedText:forTable: ) ] ) {
            [[ self dataSource ] handleChangedText: [[ aNotification object ] string ]
                                forTable: self ];
        }
        [[ self window ] endEditingFor: self ];
        [[ self window ] makeFirstResponder: self ];
        [ self reloadData ];
    } else {
        [ super textDidEndEditing: aNotification ];
    }
}

@end
