/* RSMNewFolderHelper */

#import <Cocoa/Cocoa.h>

@interface RSMNewFolderHelper : NSObject
{
    IBOutlet NSButton	    *rsmNewFolderButton;
    IBOutlet NSTextField    *rsmNewFolderNameField;
    IBOutlet NSTextField    *rsmNewFolderPathField;
    IBOutlet NSPanel	    *rsmNewFolderSheet;
    
@private
    id			    _rsmNewFolderHelperDelegate;
    NSString		    *_rsmNewFolderHelperBasePath;
}

- ( void )setDelegate: ( id )delegate;
- ( id )delegate;
- ( void )setBasePath: ( NSString * )basePath;
- ( NSString * )basePath;

- ( void )displayNewFolderSheetForWindow: ( NSWindow * )window
	    basePath: ( NSString * )basePath
	    delegate: ( id )delegate;
- ( IBAction )createNewFolder: ( id )sender;
- ( IBAction )dismissNewFolderSheet: ( id )sender;

@end

/* delegate methods */
@interface NSObject(RSMNewFolderHelper)
- ( void )folderHelperCreateFolderAtPath: ( NSString * )path;
@end
