/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "NSImage-RTEExtensions.h"

@implementation NSImage(RTEExtensions)

+ ( NSImage * )imageForType: ( char )type
{
    NSImage		*image = nil;
    
    switch ( type ) {
    case 'a':
        image = [ NSImage imageNamed: @"applefile.png" ];
        break;
    
    case 'f':
        image = [ NSImage imageNamed: @"regfile.png" ];
        break;
        
    case 'd':
        image = [ NSImage imageNamed: @"folder.png" ];
        break;
        
    case 'c':
        image = [ NSImage imageNamed: @"charspecial.png" ];
        break;
        
    case 'b':
        image = [ NSImage imageNamed: @"blockspecial.png" ];
        break;
        
    case 'D':
        image = [ NSImage imageNamed: @"door.png" ];
        break;
    
    case 'h':
        image = [ NSImage imageNamed: @"hardlink.png" ];
        break;
        
    case 'l':
        image = [ NSImage imageNamed: @"symlink.png" ];
        break;
    
    case 'p':
        image = [ NSImage imageNamed: @"namedpipe.png" ];
        break;
        
    case 's':
        image = [ NSImage imageNamed: @"socket.png" ];
        break;
        
    default:
        break;
    }
    
    return( image );
}

@end
