#import "RTETwhichDisplay.h"
#import "NSString(RXAdditions).h"

#include "argcargv.h"
#include "code.h"

@implementation RTETwhichDisplay

- ( id )init
{
    self = [ super init ];
    
    _rteTwhichString = nil;
    _rteTwhichParsedOutput = nil;
    
    return( self );
}

- ( void )awakeFromNib
{
    [ twhichMatchingTranscriptsTable setDataSource: self ];
    [ twhichMatchingTranscriptsTable setDelegate: self ];
    [ twhichMatchingTranscriptsTable setAction: @selector( twhichResultsTableClick: ) ];
    [ twhichMatchingTranscriptsTable setDoubleAction: NULL ];
    
    [ twhichResultsPanel center ];
}

/* accessor methods */
- ( void )setTwhichString: ( NSString * )twhichString
{
    if ( _rteTwhichString != nil ) {
	[ _rteTwhichString release ];
	_rteTwhichString = nil;
    }
    if ( twhichString != nil ) {
	_rteTwhichString = [ twhichString retain ];
    }
}

- ( NSString * )twhichString
{
    return( _rteTwhichString );
}

- ( void )setTwhichParsedOutput: ( NSArray * )parsedOutput
{
    if ( _rteTwhichParsedOutput != nil ) {
	[ _rteTwhichParsedOutput release ];
	_rteTwhichParsedOutput = nil;
    }
    if ( parsedOutput != nil ) {
	_rteTwhichParsedOutput = [ parsedOutput retain ];
    }
}

- ( NSArray * )twhichParsedOutput
{
    return( _rteTwhichParsedOutput );
}
/* end access methods */

- ( BOOL )parseAndDisplayTwhichString: ( NSString * )twhichString
{
    NSArray		*twhichLines;
    NSMutableArray	*parsedOutput = nil;
    NSString		*objectPath = nil;
    int			i;
    
    [ self setTwhichString: twhichString ];
    
    twhichLines = [[ self twhichString ] componentsSeparatedByString: @"\n" ];

    /*
     * twhich output looks like this:
     * # Type [Positive, Negative or Special]
     * # Command File name
     * transcript-name.T:
     * + f ./transcript/line	mode owner group size mtime cksum
     */
    for ( i = 0; i < [ twhichLines count ]; i += 4 ) {
	NSDictionary	*dict;
	NSString	*type, *commandFile, *transcript, *line;
	NSString	*modeString;
	char		*otype, *path, *owner, *group, *mode;
	char		buf[ LINE_MAX ];
	char		**tav = NULL;
	int		tac, len;
	
	if ( [ twhichLines count ] < ( i + 3 )) {
	    break;
	}
	
	type = [ twhichLines objectAtIndex: i ];
	commandFile = [ twhichLines objectAtIndex: ( i + 1 ) ];
	transcript = [ twhichLines objectAtIndex: ( i + 2 ) ];
	line = [ twhichLines objectAtIndex: ( i + 3 ) ];
	
	/* remove "# " prefix from type and command file lines */
	type = [ type substringFromIndex: 2 ];
	commandFile = [ commandFile substringFromIndex: 2 ];
	len = [ commandFile length ];
	commandFile = [ commandFile substringToIndex: ( len - 1 ) ];
	
	/* remove ":" suffix from transcript line */
	if (( len = [ transcript length ] ) < 2 ) { /* name + : */
	    NSLog( @"invalid transcript empty transcript line" );
	    continue;
	}
	transcript = [ transcript substringToIndex: ( len - 1 ) ];
	
	/* parse transcript line */
	if (( len = [ line length ] ) >= LINE_MAX ) {
	    NSLog( @"%s: too long", line );
	    continue;
	}
	memset( buf, '\0', sizeof( buf ));
	strcpy( buf, [ line UTF8String ] );
	
	if (( tac = argcargv( buf, &tav )) < 0 ) {
	    NSLog( @"argcargv for %s failed", buf );
	    continue;
	}
	if ( tac == 0 ) {
	    NSLog( @"%@: invalid transcript line", line );
	    continue;
	}
	
	if ( *tav[ 0 ] == '+' ) {
	    tav++;
	    tac--;
	}
	
	otype = tav[ 0 ];
	if (( path = decode( tav[ 1 ] )) == NULL ) {
	    NSLog( @"decode %s failed." );
	    path = tav[ 1 ];
	}

	if ( *otype != 'l' && *otype != 'h' ) {
	    mode = tav[ 2 ];
	    owner = tav[ 3 ];
	    group = tav[ 4 ];
	    modeString = [ NSString stringWithUTF8String: mode ];
	    modeString = [ modeString stringFromOctal ];
	} else {
	    mode = owner = group = "n/a";
	    modeString = [ NSString stringWithUTF8String: mode ];
	}
	
	if ( objectPath == nil ) {
	    objectPath = [[ NSString stringWithUTF8String: path ] retain ];
	}
	
	dict = [ NSDictionary dictionaryWithObjectsAndKeys:
		    type, @"RTETwhichTranscriptType",
		    commandFile, @"RTETwhichCommandFile",
		    transcript, @"RTETwhichTranscript",
		    [[ NSString stringWithUTF8String: otype ]
			    transcriptObjectTypeFromString ], @"RTETwhichObjectType",
		    objectPath, @"RTETwhichObjectPath",
		    modeString, @"RTETwhichObjectMode",
		    [ NSString stringWithUTF8String: owner ], @"RTETwhichObjectOwner",
		    [ NSString stringWithUTF8String: group ], @"RTETwhichObjectGroup",
		    nil ];
	
	if ( parsedOutput == nil ) {
	    parsedOutput = [[ NSMutableArray alloc ] init ];
	}
	
	[ parsedOutput addObject: dict ];
    }
    
    [ self setTwhichParsedOutput: [ NSArray arrayWithArray: parsedOutput ]];
    
    if ( parsedOutput != nil ) {
	[ parsedOutput release ];
    }
    
    if ( objectPath != nil ) {
	[ twhichObjectPathField setStringValue: objectPath ];
	[ objectPath release ];
    }
    
    [ twhichMatchingTranscriptsTable reloadData ];
    [ twhichResultsPanel makeKeyAndOrderFront: nil ];
    
    return( YES );
}

- ( void )twhichResultsTableClick: ( id )sender
{
    int			row = [ twhichMatchingTranscriptsTable selectedRow ];
    NSDictionary	*dict = nil;
    NSString		*commandFile, *type, *otype, *owner, *group, *mode;
    
    commandFile = type = otype = owner = group = mode = @"";
    
    if ( row >= 0 ) {
	dict = [[ self twhichParsedOutput ] objectAtIndex: row ];
	commandFile = [ dict objectForKey: @"RTETwhichCommandFile" ];
	type = [ dict objectForKey: @"RTETwhichTranscriptType" ];
	otype = [ dict objectForKey: @"RTETwhichObjectType" ];
	owner = [ dict objectForKey: @"RTETwhichObjectOwner" ];
	group = [ dict objectForKey: @"RTETwhichObjectGroup" ];
	mode = [ dict objectForKey: @"RTETwhichObjectMode" ];
    }
    
    [ twhichCommandFileField setStringValue: commandFile ];
    [ twhichTypeField setStringValue: type ];
    [ twhichObjectTypeField setStringValue: otype ];
    [ twhichOwnerField setStringValue: owner ];
    [ twhichGroupField setStringValue: group ];
    [ twhichPermissionsField setStringValue: mode ];
}

/* tableview data source methods */
- ( int )numberOfRowsInTableView: ( NSTableView * )aTableView
{
    return( [ _rteTwhichParsedOutput count ] );
}

- ( id )tableView: ( NSTableView * )view
        objectValueForTableColumn: ( NSTableColumn * )column
        row: ( int )row
{
    NSDictionary	*dict = [ _rteTwhichParsedOutput objectAtIndex: row ];
    NSString            *key = [ column identifier ];
    
    return( [ dict objectForKey: key ] );
}

/* tableview delegate methods */
- ( void )tableViewSelectionDidChange: ( NSNotification * )notification
{
    [ self twhichResultsTableClick: nil ];
}

@end
