#import "RXTranscript-ConversionAdditions.h"

@implementation RXTranscript(ConversionAdditions)

/*
 * return values:
 *  -1: error
 *   0: no conversion necessary
 *   1: converted successfully
 */
- ( int )convertTranscriptBaseToPath: ( NSString * )basepath
{
    NSAutoreleasePool	    *pool;
    NSMutableArray          *transcriptLines = [[ self transcriptContents ] mutableCopy ];
    NSString                *path = nil, *currentbase = nil;
    NSMutableDictionary     *item = nil;
    int                     i = 0;
    
    NSAssert(( transcriptLines != nil ), @"transcriptLines == nil!" );
    
    item = [ transcriptLines objectAtIndex: 0 ];
    currentbase = [[ item objectForKey: @"path" ] substringToIndex: 1 ];
    
    if ( [[ item objectForKey: @"path" ] isEqualToString: @"." ]
            || [[ item objectForKey: @"path" ] isEqualToString: @"./" ]
            || [[ item objectForKey: @"path" ] isEqualToString: @"/" ] ) {
        [[ transcriptLines objectAtIndex: 0 ] setObject: basepath
                                                forKey: @"path" ];
        i = 1;
    }
    
    pool = [[ NSAutoreleasePool alloc ] init ];
    for ( ; i < [ transcriptLines count ]; i++ ) {
        path = [[ transcriptLines objectAtIndex: i ] objectForKey: @"path" ];
        
        if ( [ path length ] < 2 ) {
            continue;
        }
        
        if ( [[ path substringToIndex: 2 ] isEqualToString: @"./" ]
                    && [ path length ] >= 2
                    && [ basepath isEqualToString: @"/" ] ) {
            path = [ path substringFromIndex: 1 ];
            [[ transcriptLines objectAtIndex: i ] setObject: path
                                                    forKey: @"path" ];
						    
	    if ( [[[ transcriptLines objectAtIndex: i ]
			objectForKey: @"type" ] isEqualToString: @"h" ] ) {
		path = [[ transcriptLines objectAtIndex: i ] objectForKey: @"dest" ];
		if ( path != nil &&
			[[ path substringToIndex: 2 ] isEqualToString: @"./" ] ) {
		    path = [ path substringFromIndex: 1 ];
		    [[ transcriptLines objectAtIndex: i ] setObject: path
							    forKey: @"dest" ];
		}
	    }
	    
            continue;
        }
        
        if ( [[ path substringToIndex: 1 ] isEqualToString: @"/" ]
                    && [ path length ] >= 2
                    && ! [ basepath isEqualToString: @"/" ] ) {
            path = [ NSString stringWithFormat: @"%@%@",
                            [ basepath substringToIndex: 1 ], path ];
            [[ transcriptLines objectAtIndex: i ] setObject: path
                                                    forKey: @"path" ];
	    
	    if ( [[[ transcriptLines objectAtIndex: i ]
			objectForKey: @"type" ] isEqualToString: @"h" ] ) {
		path = [[ transcriptLines objectAtIndex: i ] objectForKey: @"dest" ];
		if ( path != nil &&
			[[ path substringToIndex: 1 ] isEqualToString: @"/" ] ) {
		    path = [ NSString stringWithFormat: @"%@%@",
			    [ basepath substringToIndex: 1 ], path ];
		    [[ transcriptLines objectAtIndex: i ] setObject: path
							    forKey: @"dest" ];
		}
	    }
        }
    }
    [ pool release ];
    
    [ self setTranscriptContents: transcriptLines ];
    [ transcriptLines autorelease ];
    
    return( 1 );
}

@end
