/*
Copyright (c) 2002 Regents of The University of Michigan.
All Rights Reserved.

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appears in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of The University
of Michigan not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission. This software is supplied as is without expressed or
implied warranties of any kind.

Research Systems Unix Group
The University of Michigan
c/o Wesley Craig
4251 Plymouth Road B1F2, #2600
Ann Arbor, MI 48105-2785

http://rsug.itd.umich.edu/software/radmind
radmind@umich.edu
*/

#import <Cocoa/Cocoa.h>

#import "RXAuthRW.h"
#import "RXTableView.h"
#import "RTESearchField.h"
#import "RMSplitView.h"
#import "RTEAuditorDisplay.h"
#import "RTETwhichDisplay.h"

#include <pwd.h>
#include <grp.h>

/* toolbar identifiers */
#define RTEToolbarInfoIdentifier		@"RTEToolbarInfo"
#define RTEToolbarSaveIdentifier		@"RTEToolbarSave"
#define RTEToolbarViewTypeIdentifier            @"RTEToolbarViewType"
#define RTEToolbarDeleteIdentifier              @"RTEToolbarDelete"
#define RTEToolbarSearchIdentifier              @"RTEToolbarSearch"
#define RTEToolbarConvertIdentifier             @"RTEToolbarConvert"
#define RTEToolbarToggleCommentIdentifier       @"RTEToolbarToggleComment"
#define RTEToolbarAddCommentIdentifier          @"RTEToolbarAddComment"
#define RTEToolbarAuditIdentifier		@"RTEToolbarAudit"
#define RTEToolbarTwhichIdentifier		@"RTEToolbarTwhich"

/* custom pasteboard type */
#define RTETranscriptContentsPboardType         @"RTETranscriptContents"

#define RXLISTVIEW	0
#define RXCOLUMNVIEW	1

#define SEARCH		1
#define NORMAL		0

/* search types */
enum {
    PATHSEARCH = 0,
    TYPESEARCH = 1,
    OWNERSEARCH = 2,
    GROUPSEARCH,
    PERMSEARCH,
    MINUSSEARCH,
    PLUSSEARCH
};

@interface RXTranscript : NSDocument
{
    /* drawer outlets */
    IBOutlet NSDrawer			*transcriptLineDrawer;
    IBOutlet NSTextView			*transcriptLineView;

    /* list view outlets */
    IBOutlet NSView			*tableView;
    IBOutlet RXTableView		*tContentsTableView;
    IBOutlet NSTableColumn		*lineNumberColumn;
    IBOutlet NSMenu                     *conversionMenu;

    /* browser view outlets */
    IBOutlet NSView			*browserView;
    IBOutlet NSBrowser			*transcriptBrowser;
    IBOutlet NSTextField		*pathField;
    
    /* save progress outlets */
    IBOutlet NSPanel			*saveProgPanel;
    IBOutlet NSTextField		*progMsg;
    IBOutlet NSProgressIndicator	*saveProgBar;
    
    /* advanced search panel outlets */
    IBOutlet NSPanel			*advancedSearchPanel;
    IBOutlet NSTextField		*advancedSearchField;
    IBOutlet NSPopUpButton		*advancedSearchTypeButton;
    IBOutlet NSButton			*advancedSearchCaseSensitivity;
    
    /* go to line panel */
    IBOutlet NSPanel			*gotoLinePanel;
    IBOutlet NSTextField		*gotoLineField;
    
    /* window split view */
    IBOutlet RMSplitView                *transcriptSplitView;
    
    /* info */
    IBOutlet NSTabView                  *infoTabView;
    IBOutlet NSTextField		*nameField;
        /* general info outlets */
        IBOutlet NSTextField		*kind;
        IBOutlet NSTextField		*where;
        IBOutlet NSTextField		*owner;
        IBOutlet NSTextField		*group;
        IBOutlet NSTextField		*size;
        IBOutlet NSTextField		*modified;
        IBOutlet NSTextField		*permissionsField;
        IBOutlet NSTextField		*chksum;
        IBOutlet NSImageView		*typeImage;
        IBOutlet NSButton		*editButton;
        /* edit owner and group outlets */
        IBOutlet NSTextField		*editOwnerUIDField;
        IBOutlet NSTextField		*editGroupGIDField;
        /* edit permissions outlets */
        IBOutlet NSButton		*setuidSwitch;
        IBOutlet NSButton		*setgidSwitch;
        IBOutlet NSButton		*stickySwitch;
        IBOutlet NSButton		*owReadSwitch;
        IBOutlet NSButton		*owWriteSwitch;
        IBOutlet NSButton		*owExecSwitch;
        IBOutlet NSButton		*grReadSwitch;
        IBOutlet NSButton		*grWriteSwitch;
        IBOutlet NSButton		*grExecSwitch;
        IBOutlet NSButton		*otReadSwitch;
        IBOutlet NSButton		*otWriteSwitch;
        IBOutlet NSButton		*otExecSwitch;
        IBOutlet NSTextField		*octalModeField;
        /* manual edit outlets */
        IBOutlet NSTextField             *editedTranscriptLineField;
    
    /* toolbar views */
    IBOutlet RTESearchField		*tbSearchField;
    
    IBOutlet NSTextField		*lineCountField;
    IBOutlet NSTextField                *loadsetSizeField;
    IBOutlet NSBox			*box;
    IBOutlet NSWindow			*tWindow;
    IBOutlet NSProgressIndicator	*loadProgressIndicator;
    IBOutlet NSView                     *transcriptHeaderView;
    
    /* add item outlets */
    IBOutlet NSPanel			*addItemPanel;
    IBOutlet NSTextField		*addItemPathField;
    IBOutlet NSButton			*addItemButton;
    
    RTEAuditorDisplay			*auditorDisplay;
    RTETwhichDisplay			*twhichDisplay;

@private
    int					viewtype, mode;
    int                                 _rteThreadID;
    unsigned long			lindex;
    double				prog;
    BOOL                                _isSearching;
    
    id					_rteTranscriptDelegate;
    NSMutableArray			*columnContents, *parsedLines, *searchResults;
    //NSMutableArray			*curColumnItems;
    //NSView				*origSuperView;
    
            /* for distributed objects */
    NSConnection			*connectionToAuthRW;
    RXAuthRW				*arw;
}

/* accessor methods */
- ( void )setTranscriptContents: ( NSMutableArray * )contents;
- ( NSMutableArray * )transcriptContents;

- ( void )setDelegate: ( id )delegate;
- ( id )delegate;

- ( void )setHelperThreadID: ( int )ID;
- ( int )helperThreadID;

/* info panel methods */
- ( IBAction )showInfo: ( id )sender;
- ( IBAction )changeOwner: ( id )sender;
- ( IBAction )changeGroup: ( id )sender;
- ( IBAction )permissionSwitchClick: ( id )sender;
- ( void )setupPermissionSwitchesForMode: ( NSString * )octalmode;
- ( IBAction )setPermissions: ( id )sender;
- ( IBAction )saveManuallyEditedTranscriptLine: ( id )sender;

- ( void )updateIndices;
- ( void )toolbarSetup;
//- ( void )arrangeColumn: ( int )column withOffset: ( int )offset toOffset: ( int )end;
//- ( BOOL )isVisibleObject: ( NSString * )object atIndex: ( int )index
//                        withParent: ( NSString * )parent;

- ( void )setServer: ( id )serverObject threadID: ( int )threadID;
- ( oneway void )DOSetupCompleteInThreadWithID: ( int )threadID;

- ( void )readTranscriptCopyAtPath: ( NSString * )path threadID: ( int )ID;
- ( void )setMaxLoadIndicatorValue: ( double )value;
- ( void )readFile: ( NSDictionary * )contextInfo;
- ( void )readFinishedFromThreadWithID: ( int )ID;
- ( oneway void )addLines: ( NSArray * )lines fromThreadWithID: ( int )ID;
- ( void )setReadProgressMessage: ( NSString * )message;
- ( BOOL )executeAuthorizedAction: ( int )action arguments: ( NSArray * )arguments;
- ( oneway void )readError: ( char * )errmsg fromThreadWithID: ( int )ID;
- ( void )writeFinishedFromThreadWithID: ( int )threadID;
- ( oneway void )authorizationFailedInThreadWithID: ( int )threadID;

- ( void )deleteSelectedLines: ( id )sender;
- ( void )calculateAndDisplayLoadsetSize;

- ( void )auditTranscript: ( id )sender;

/* twhich methods */
- ( void )showSourceTranscripts: ( id )sender;
- ( oneway void )displayTwhichOutput: ( NSString * )output
		    fromThreadWithID: ( int )ID;

/* comment methods */
- ( IBAction )toggleCommentOnSelectedLine: ( id )sender;

/* search related methods */
- ( void )cancelSearchMode;
- ( void )search: ( id )sender;
- ( IBAction )advancedSearch: ( id )sender;
- ( void )setAdvancedSearchType: ( int )type;
- ( int )advancedSearchType;
- ( IBAction )setSearchType: ( id )sender;
- ( IBAction )displayAdvancedSearchPanel: ( id )sender;
- ( IBAction )dismissAdvancedSearchPanel: ( id )sender;
- ( void )searchFor: ( NSString * )searchString searchType: ( int )type
        caseInsensitive: ( BOOL )ci;
	
/* go to line */
- ( IBAction )showGotoLinePanel: ( id )sender;
- ( IBAction )gotoLine: ( id )sender;
        
/* conversion methods */
- ( IBAction )convertTranscriptBasePath: ( id )sender;
- ( IBAction )convertBasePath: ( id )sender;
	
/* add item methods */
- ( IBAction )getAddItemSheet: ( id )sender;
- ( IBAction )chooseItem: ( id )sender;
- ( IBAction )addItem: ( id )sender;
- ( IBAction )cancelAddItem: ( id )sender;

- ( IBAction )toggleDrawer: ( id )sender;

- ( NSString * )retrievePassword;

@end

/* delegate methods */
@interface NSObject(RXTranscript)
- ( NSString * )sessionUserName;
@end
