/*
 * Copyright (c) 2005 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import <Cocoa/Cocoa.h>

#define RUMUpdatesCheckingNotification	@"RUMUpdatesCheckingNotification"
#define RUMUpdatesAvailableNotification	@"RUMUpdatesAvailableNotification"
#define RUMUpdatesNoneNotification	@"RUMUpdatesNoneNotification"
#define RUMUpdatesErrorNotification	@"RUMUpdatesErrorNotification"

#define RUM_QUIT_STRING			NSLocalizedString( \
					    @"Quit", \
					    @"Quit" )
#define RUM_OPEN_ASSISTANT_STRING	NSLocalizedString( \
					    @"Open Radmind Assistant", \
					    @"Open Radmind Assistant" )
#define	RUM_UPDATE_CHECK_STRING		NSLocalizedString( \
					    @"Checking for updates", \
					    @"Checking for updates" )
#define RUM_UPDATES_AVAILABLE_STRING	NSLocalizedString( \
					    @"Updates available", \
					    @"Updates available" )
#define RUM_NO_UPDATES_STRING		NSLocalizedString( \
					    @"No updates", \
					    @"No updates" )
#define RUM_ERROR_STRING		NSLocalizedString( \
					    @"No updates", \
					    @"No updates" )

@interface RUMController : NSObject
{
    NSStatusItem	*statusItem;
    NSMenu		*statusMenu;
    
@private
    NSArray		*updateImageArray;
    NSTimer		*animationTimer;
    int			frameno;
}

- ( void )activateStatusMenu;
- ( void )addGeneralMenuItems;
- ( void )openRadmindAssistant: ( id )sender;

- ( void )radmindCheckingForUpdates: ( id )sender;
- ( void )radmindUpdatesAvailable: ( id )sender;
- ( void )radmindNoUpdatesAvailable: ( id )sender;
- ( void )radmindUpdateCheckError: ( id )sender;

@end
