/********************************************************************************
*                                                                               *
*              FoxSweeper game                                                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This program is free software; you can redistribute it and/or modify          *
* it under the terms of the GNU General Public License as published by          *
* the Free Software Foundation; either version 2 of the License, or             *
* (at your option) any later version.                                           *
*                                                                               *
* This program is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
* GNU General Public License for more details.                                  *
*                                                                               *
* You should have received a copy of the GNU General Public License             *
* along with this program; if not, write to the Free Software                   *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FOXSWEEPER_H
#define FOXSWEEPER_H

// FoxSweeper Main Window
class FoxSweeper : public FXMainWindow{
  FXDECLARE(FoxSweeper)

public:
  enum GameLevel { Beginner=0, Intermediate, Advanced, Custom };
  static FXString gameLevel[4];

private:
  FoxSweeper(){}
  void saveSettings();
  void loadSettings();

private:
  Icons             *icons;
  FXToolTip         *tooltip;
  FXToolBarShell    *toolbarShell;
  FXToolBar         *toolbar;
  FXButton          *exitButton;
  FXButton          *newButton;
  FXButton          *pauseButton;
  FXButton          *settingsButton;
  FXButton          *highscoreButton;
  FXButton          *aboutButton;
  FXDataTarget      *countTarget;
  FXLCDLabel        *bombField;
  FXLabel           *flagLabel;
  FXMatrix          *matrix;

  FXuint             randomSeed;
  point              gridSize;
  fsGridPointerArray gridData;

  FXuint             buttonTotal;
  FXuint             buttonCount;
  FXint              bombTotal;
  FXint              bombCount;
  FXuint             currentTime;
  GameLevel          mode;

private:
  static FXuint      maxBombs;
  static FXuint      minBombs;
  static FXuint      maxSize;
  static FXuint      minSize;
  static FXuint      maxTime;
  static FXuint      defaultButtonSize;
  static FXuint      defaultGridSize;
  static FXuint      clockUpdateRate;

public:
  enum {
    ID_ABOUT=FXMainWindow::ID_LAST,
    ID_DISCLAIM,
    ID_QUIT,
    ID_MAINWINDOW,
    ID_NEW_GAME,
    ID_PAUSE,
    ID_SETTINGS,
    ID_HIGH_SCORE,
    ID_HS_BEGINNER,
    ID_HS_INTERMEDIATE,
    ID_HS_ADVANCED,
    ID_HS_CUSTOM,
    ID_LEFT_CLICK,
    ID_MIDDLE_CLICK,
    ID_RIGHT_CLICK,
    ID_BUTTON,
    ID_NROWS,
    ID_NCOLS,
    ID_NBOMBS,
    ID_TIMER,
    ID_BEGINNER,
    ID_INTERMEDIATE,
    ID_ADVANCED,
    ID_CUSTOM,
    ID_LAST
    };

public:
  long onCmdQuit       (FXObject*,FXSelector,void*);
  long onCmdAbout      (FXObject*,FXSelector,void*);
  long onCmdNewGame    (FXObject*,FXSelector,void*);
  long onCmdPause      (FXObject*,FXSelector,void*);
  long onUpdPause      (FXObject*,FXSelector,void*);
  long onCmdSettings   (FXObject*,FXSelector,void*);
  long onCmdHighScore  (FXObject*,FXSelector,void*);
  long onCmdLeftClick  (FXObject*,FXSelector,void*);
  long onCmdMiddleClick(FXObject*,FXSelector,void*);
  long onCmdRightClick (FXObject*,FXSelector,void*);
  long onCmdNRows      (FXObject*,FXSelector,void*);
  long onCmdNCols      (FXObject*,FXSelector,void*);
  long onCmdNBombs     (FXObject*,FXSelector,void*);
  long onUpdNRows      (FXObject*,FXSelector,void*);
  long onUpdNCols      (FXObject*,FXSelector,void*);
  long onUpdNBombs     (FXObject*,FXSelector,void*);
  long onTimer         (FXObject*,FXSelector,void*);
  long onCmdMode       (FXObject*,FXSelector,void*);
  long onUpdMode       (FXObject*,FXSelector,void*);
  long onUpdHighScore  (FXObject*,FXSelector,void*);

public:
  FoxSweeper(FXApp* a);
  ~FoxSweeper();
  virtual void create();

  FXint rand(FXint scale);
  FXbool questionBox(const FXString& title,const FXString& contents);

  void generateBombSet();
  void makeGrid();
  void deleteGrid();
  FXbool evaluateThisLocation(FXuint x, FXuint y);
  void evaluateSurroundingLocation(FXuint x, FXuint y);
  void evalEndGame();
  void showRemainingBombs();
  void modeBeginner();
  void modeIntermediate();
  void modeAdvanced();
  void addHighScore();
};

#endif
