/********************************************************************************
*                                                                               *
*              Generic 2D grid data                                             *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This program is free software; you can redistribute it and/or modify          *
* it under the terms of the GNU General Public License as published by          *
* the Free Software Foundation; either version 2 of the License, or             *
* (at your option) any later version.                                           *
*                                                                               *
* This program is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
* GNU General Public License for more details.                                  *
*                                                                               *
* You should have received a copy of the GNU General Public License             *
* along with this program; if not, write to the Free Software                   *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <fox/fx.h>
#include "GridPointerArray.h"

// ctor
GridPointerArray::GridPointerArray(FXuint x,FXuint y) :list(NULL),xamount(0),yamount(0){
  if (x&&y) size(x,y);
  }

// dtor
GridPointerArray::~GridPointerArray(){
  size(0,0);
  }

// resize the array
point GridPointerArray::size(FXuint x,FXuint y){
  GridElement *p;
  FXuint i;
  FXuint j;

  for(i=0; i<xamount; i++){
    for(j=0; j<yamount; j++){
      p=list;
      list=p->next;
      delete p;
      }
    }
  list=NULL;
  xamount=0;
  yamount=0;

  for(j=y; j>0; j--){
    for(i=x; i>0; i--){
      p=new GridElement();
      p->next=list;
      list=p;
      }
    }
  xamount=x;
  yamount=y;

  return point(xamount,yamount);
  }

// add data to an aray position
point GridPointerArray::insert(FXuint x,FXuint y,void* data){
  FXASSERT(x<xamount&&y<yamount);
  GridElement *p = get(x,y);
  p->data=data;
  return point(x,y);
  }

// get a element of an array position
GridElement* GridPointerArray::get(FXuint x,FXuint y){
  FXASSERT(x<xamount&&y<yamount);
  GridElement *p=list;
  FXuint i;
  FXuint j;
  for (j=0; j<y; j++){
    for (i=0; i<xamount; i++){
      p=p->next;
      }
    }
  for (i=0; i<x; i++){
    p=p->next;
    }
  return p;
  }

// return pointer to data at that position
void* GridPointerArray::find(FXuint x,FXuint y){
  GridElement *p = get(x,y);
  return p->data;
  }

