/********************************************************************************
*                                                                               *
*              FoxSweeper 2D grid data                                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This program is free software; you can redistribute it and/or modify          *
* it under the terms of the GNU General Public License as published by          *
* the Free Software Foundation; either version 2 of the License, or             *
* (at your option) any later version.                                           *
*                                                                               *
* This program is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
* GNU General Public License for more details.                                  *
*                                                                               *
* You should have received a copy of the GNU General Public License             *
* along with this program; if not, write to the Free Software                   *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <fox/fx.h>
#include "GridPointerArray.h"
#include "fsButton.h"
#include "fsGridPointerArray.h"

point fsGridPointerArray::size(FXuint x,FXuint y){
  FXuint i;
  FXuint j;

  fsButtonData *b;
  for (i=0; i<xsize(); i++){
    for (j=0; j<ysize(); j++){
      b=find(i,j);
      delete b;
      }
    }

  GridPointerArray::size(x,y);

  GridElement *p;
  for (i=0; i<x; i++){
    for (j=0; j<y; j++){
      p=get(i,j);
      p->data = (void*) new fsButtonData();
      }
    }

  return point(x,y);
  }

point fsGridPointerArray::insert(FXuint x,FXuint y,fsButtonData* data){
  return GridPointerArray::insert(x,y,(void*)data);
  }

fsButtonData* fsGridPointerArray::find (FXuint x,FXuint y){
  return (fsButtonData*) GridPointerArray::find(x,y);
  }
