#!/bin/sh

if [ -z "$1" -o "$1" = "-h" ]; then
  echo "usage: $0 <path to fox-1.1.{latest}>"
  exit 1
fi

if [ ! -d "$1" ]; then
  echo "Unknown directory: $1"
  exit 1
fi

echo "Applying patches..."

patch "$1/include/FXCharset.h"     "FOX-patches/FXCharset.h.patch"
patch "$1/include/FXFont.h"        "FOX-patches/FXFont.h.patch"
patch "$1/include/FXSpinner.h"     "FOX-patches/FXSpinner.h.patch"
patch "$1/src/FXDCPrint.cpp"       "FOX-patches/FXDCPrint.cpp.patch"
patch "$1/src/FXDCWindow.cpp"      "FOX-patches/FXDCWindow.cpp.patch"
patch "$1/src/FXFont.cpp"          "FOX-patches/FXFont.cpp.patch"
patch "$1/src/FXFontSelector.cpp"  "FOX-patches/FXFontSelector.cpp.patch"
patch "$1/src/FXSpinner.cpp"       "FOX-patches/FXSpinner.cpp.patch"

echo "...patches applied"

