/********************************************************************************
*                                                                               *
*                          E x c e p t i o n  T y p e s                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 2000,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXException.h,v 1.5 2001/02/08 16:49:51 jeroen Exp $                     *
* Modifed 2001/09/26 ned
********************************************************************************/
#ifndef FXEXCEPTION_H
#define FXEXCEPTION_H

// When defined as:
//    1: use try...throw...catch
//    2: emulate with setjmp/longjmp
//    0 or undefined: disable
#define FXEXCEPTION_EXCPTHANDLING 0

// Max length of error message
#define FXEXCEPTION_MAXMSGLEN 1024

// General error handling macros
#define FXERRMAKE(e2,msg,code,flags)	FXException e2(__FILE__, __LINE__,msg,code,flags);
#define FXERRG(msg,code,fatal)		{ FXERRMAKE(e,msg,code,fatal); FXERRH_THROW(e); }

// Memory allocation failure handler
// Note: all customised error handling here working off FXEXCEPTION_SYSCODE_BASE
#define FXEXCEPTION_SYSCODE_BASE	0x10000000
#define FXEXCEPTION_NOMEMORY	(FXEXCEPTION_SYSCODE_BASE + 0)
#define FXERRHM(exp)		if(!(exp)) FXERRG("Out of memory",FXEXCEPTION_NOMEMORY,0);

// Error creation flags
#define FXERRH_ISFATAL		1
#define FXERRH_ISNORETRY	2


// Which implementation are we choosing...?
#if FXEXCEPTION_EXCPTHANDLING == 1


// Implementation as written using try...throw...catch
class FXAPI FXException_FinallyHelper {
public:
  inline FXException_FinallyHelper() {}
  inline ~FXException_FinallyHelper() { throw this; }
  };

#define FXERRH_TRY		{ bool __retryerrorh; do { __retryerrorh=false; try
#define FXERRH_THROW(e)		throw e;
#define FXERRH_CATCH(e)		catch(e)
#define FXERRH_REPORT(e)	if(e.report()) __retryerrorh=true;
#define FXERRH_ENDTRY		} while(__retryerrorh); }
#define FXERRH_TRYF		FXException __finallyerrorcopy; try { FXException_FinallyHelper __finallyhelper; try
#define FXERRH_FINALLY		catch(FXException e) { __finallyerrorcopy=e;} } catch(FXException_FinallyHelper *) {
#define FXERRH_ENDTRYF		if(__finallyerrorcopy.valid) throw __finallyerrorcopy; }

#define FXERRH_STARTV
#define FXERRH_START(type, def)
#define FXERRH_RETURNV		return
#define FXERRH_RETURN(val)	return val
#define FXERRH_ENDV
#define FXERRH_END


#elif FXEXCEPTION_EXCPTHANDLING == 2


// The implementation based on setjmp()
#include <setjmp.h>
#define FXERRH_TRY		{ FXException __errorstate; bool __retryerrorh; int __trytype; do { bool __nestedtry=true; jmp_buf __trypoint; __retryerrorh=false; __trytype=setjmp(__trypoint); if(!__trytype) {
#define FXERRH_THROW(e)		__errorstate=e; { int a=(!__trytype)?1:__trytype; __trytype=2; longjmp(__trypoint,a); }
#define FXERRH_CATCH(e)		} else if(1==__trytype && __errorstate.valid) { e=__errorstate;
#define FXERRH_REPORT(e)	{ if(e.report()) __retryerrorh=true; __errorstate.valid=false; }
#define FXERRH_ENDTRY		} } while(__retryerrorh); if(1==__trytype) { if(__errorstate.valid) __errorstate.report(); if(__nestedtry) longjmp(__trypoint, 2); else goto __end; } }
#define FXERRH_TRYF		{ int __trytype; { bool __nestedtry=true; jmp_buf __trypoint; __trytype=setjmp(__trypoint); if(!__trytype)
#define FXERRH_FINALLY		else
#define FXERRH_ENDTRYF		} if(1==__trytype) { if(__nestedtry) longjmp(__trypoint, 1); else { __errorstate.report(); goto __end; } } }
#define FXERRH_STARTV		FXException __errorstate; jmp_buf __trypoint; bool __nestedtry=false
#define FXERRH_START(type, def)	type __returnval=def; FXERRH_STARTV
#define FXERRH_RETURNV		longjmp(__trypoint, 1)
#define FXERRH_RETURN(val)	__returnval=val; longjmp(__trypoint, 1)
#define FXERRH_ENDV		__end: return
#define FXERRH_END		__end: return __returnval

#else


// The disabled implementation
#define FXERRH_TRY		{
#define FXERRH_THROW(e)		e.report(); goto __end;
#define FXERRH_CATCH(e)		} if(0) { e;
#define FXERRH_REPORT(e)	e.report()
#define FXERRH_ENDTRY		}
#define FXERRH_TRYF		{
#define FXERRH_FINALLY		} {
#define FXERRH_ENDTRYF		}
#define FXERRH_STARTV		
#define FXERRH_START(type, def)	type __returnval=def;
#define FXERRH_RETURNV		goto __end;
#define FXERRH_RETURN(val)	__returnval=val; goto __end;
#define FXERRH_ENDV		__end: return
#define FXERRH_END		__end: return __returnval


#endif // implemention choice



class FXApp;

/// Generic catch-all exception
class FXAPI FXException {
public:
  bool valid;
private:
  FXApp *app;
  FXchar message[FXEXCEPTION_MAXMSGLEN];
  FXint code;
  int flags;
  const FXchar *srcfilename;
  FXuint srclineno;
  FXchar *reporttxt;
  FXuint reporttxtlen;
private:
  static const FXchar exceptionName[];
public:
  FXException() { valid=false; }
  FXException(const FXchar *msg);
  FXException(const FXchar *filename,FXuint lineno,FXchar *msg,FXint code,int flags);
  const FXchar *what();
  bool report();
  virtual ~FXException();
  };


/// Generic error exception
class FXAPI FXErrorException : public FXException {
private:
  static const FXchar exceptionName[];
public:
  FXErrorException():FXException(FXErrorException::exceptionName){}
  FXErrorException(const FXchar *msg):FXException(msg){}
  };


/// Index out of range
class FXAPI FXRangeException : public FXErrorException {
private:
  static const FXchar exceptionName[];
public:
  FXRangeException():FXErrorException(FXRangeException::exceptionName){}
  FXRangeException(const FXchar *msg):FXErrorException(msg){}
  };


/// Invalid pointer 
class FXAPI FXPointerException : public FXErrorException {
private:
  static const FXchar exceptionName[];
public:
  FXPointerException():FXErrorException(FXPointerException::exceptionName){}
  FXPointerException(const FXchar *msg):FXErrorException(msg){}
  };


/// Generic resource exception
class FXAPI FXResourceException : public FXException {
private:
  static const FXchar exceptionName[];
public:
  FXResourceException():FXException(FXResourceException::exceptionName){}
  FXResourceException(const FXchar *msg):FXException(msg){}
  };


/// Out of memory
class FXAPI FXMemoryException : public FXResourceException {
private:
  static const FXchar exceptionName[];
public:
  FXMemoryException():FXResourceException(FXMemoryException::exceptionName){}
  FXMemoryException(const FXchar *msg):FXResourceException(msg){}
  };
  

#endif

