#ifndef FXSOCKET_H
#define FXSOCKET_H

#include <fx.h>

#define SOCK_BUFFER_SIZE 32768
#define POLL_TIME 10

#ifdef WIN32
#include <winsock2.h>
#include <windows.h>
  #define FXSOCKET SOCKET
  #define MSG_NOSIGNAL (0)
  #define socklen_t int
#else
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
  #define FXSOCKET int
  #define INVALID_SOCKET_HANDLE (-1)
  #define SOCKET_ERROR (-1)
#endif
#define SOCKET_MSGSIZE (-2)
#define SOCKET_RETRY (-3)

class FXSocket;

enum FXSocketEventType {
// from FXSocket
  SOCK_CONNECT,
  SOCK_DISCONNECT,
  SOCK_READ,
  SOCK_WRITE,
  SOCK_ERROR,
// only from FXServerSocket
  SOCK_SERVERROR,
  SOCK_SERVDISCONNECT,
  SOCK_CONNREJECT,
  SOCK_LAST
};

struct FXSocketEvent {
  FXSocketEventType eventType;
  FXSocket *Socket;
  FXint idata;
  void *vdata;
  FXint errorCode;
};


class FXSocket: public FXObject {
  FXDECLARE(FXSocket)
  friend class FXServerSocket;
private:
  FXchar *read_buf;
  long read_items;
  FXchar *write_buf;
  long write_items;
  FXbool connected;
  FXSOCKET sock;

  FXApp *app;
  FXObject *tgt;
  FXSelector sel;

  long read_data();
  long write_data();

protected:
  static void socket_inc_count();
  static void socket_dec_count();
  static FXSOCKET socket_create();
  static FXint socket_close(FXSOCKET socket);

  struct sockaddr_in remoteSide;
  struct sockaddr_in localSide;
  FXSocket() { socket_inc_count(); }
  void setConnected(FXbool connected, struct sockaddr_in *remoteSide = NULL);
  long raiseError(FXint errorCode, FXchar *msg = NULL, FXint idata = 0);
  long sendEvent(FXSocketEventType eventType, FXint idata = 0, void *vdata = NULL, FXint errorCode = 0);
  FXSOCKET getSocket() const { return sock; }
  FXSOCKET newSocket(FXSOCKET sock = INVALID_SOCKET_HANDLE);

public:
  FXSocket(FXApp *app, FXObject *tgt, FXSelector sel);
  ~FXSocket();
  virtual void create();


  FXApp *getApp() const { return app; };
  long disconnect();
  FXbool isConnected() const { return connected; }
  FXint read(void *buf, FXint size);
  FXint write(const void *buf, FXint size);
  FXint dataAvail() { return read_items; }
  FXint readString(FXString &s);
  FXint writeString(const FXString &s);
  FXint getLocalPort() const { return ntohs(localSide.sin_port); }
  FXString getLocalAddress() const { return inet_ntoa(localSide.sin_addr); }
  FXint getRemotePort() const { return ntohs(remoteSide.sin_port); }
  FXString getRemoteAddress() const { return inet_ntoa(remoteSide.sin_addr); }

// Private
  enum {
    ID_NONE,
    ID_INPUT,
    ID_LAST
  };
  long onIORead(FXObject *sender, FXSelector sel, void *data);
  long onIOWrite(FXObject *sender, FXSelector sel, void *data);
};

#endif
