/********************************************************************************
*                                                                               *
*                  OpenAL Device adapter class                                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Sander Jansen.   All Rights Reserved.                   *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifdef HAVE_LIBOPENAL
#ifndef FXALDEVICE_H
#define FXALDEVICE_H

#ifndef FXID_H
#include <fox/FXId.h>
using namespace FX;
#endif
namespace FXEX {
class FXALContext;

/**
 * FXALDevice is an instance of a real device, as defined as an OpenAL device
 */
class FXAPI FXALDevice : public FXId {
  FXDECLARE(FXALDevice)
  friend class FXALContext;

  protected:
    void *dev;           //OpenAL Device
    FXString deviceid;   //Device id string

  public:
    /// create an OpenAL device
    FXALDevice(FXApp * a=NULL,FXchar * deviceid="");

    /// create resources
    virtual void create();

    /// destroy resources
    virtual void destroy();

    /// attach to device
    virtual void attach(FXchar *deviceid="");

    /// dtor
    virtual ~FXALDevice();
  };

} // namespace FXEX
#endif // FXALDEVICE_H
#endif
