/********************************************************************************
*                                                                               *
*                  Digital clock                                                *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXCLOCKBUTTON_H
#define FXCLOCKBUTTON_H

#ifndef FXBUTTON_H
#include <fox/FXButton.h>
using namespace FX;
#endif
namespace FXEX {

/// ClockButton styles
enum {
  CLOCKBUTTON_SECONDS = 0x10000000,  /// show the 'seconds' value
  CLOCKBUTTON_SYMBOL  = 0x20000000,  /// show the am/pm symbol
  CLOCKBUTTON_24HOUR  = 0x40000000,  /// use 24 hour clock
  };

/**
 * A plain old digital clock - eg. for use in the status line of your app.
 * you can click on it to generate the appropriate FOX events.
 */
class FXAPI FXClockButton : public FXButton {
  FXDECLARE(FXClockButton)

protected:
  FXString   timeFormat;

protected:
  /// serialisation
  FXClockButton();

  /// Set the time/date format to that defined by FXTime
  void setFormat();

public:
  enum {
    ID_CLOCK_UPDATE=FXButton::ID_LAST,
    ID_TOGGLE_SECONDS,
    ID_TOGGLE_HOURMODE,
    ID_TOGGLE_SYMBOL,
    ID_LAST
    };

public:
  long onClockTimeout(FXObject*,FXSelector,void*);
  long onCmdToggleSeconds(FXObject*,FXSelector,void*);
  long onUpdToggleSeconds(FXObject*,FXSelector,void*);
  long onCmdToggleHourMode(FXObject*,FXSelector,void*);
  long onUpdToggleHourMode(FXObject*,FXSelector,void*);
  long onCmdToggleSymbol(FXObject*,FXSelector,void*);
  long onUpdToggleSymbol(FXObject*,FXSelector,void*);

public:
  /// Make a new ClockButton
  FXClockButton(FXComposite* p,FXObject* tgt=NULL,FXSelector sel=0,
                FXuint opts=BUTTON_TOOLBAR|FRAME_RAISED|FRAME_THICK|JUSTIFY_NORMAL|ICON_BEFORE_TEXT,
                FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,
                FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

  /// create
  virtual void create();

  /// get the current format, as defined by FXTime
  FXString getFormat() { return timeFormat; }

  /// Show seconds
  void seconds(FXbool mode);

  /// are we showing the seconds?
  FXbool seconds() { return (options&CLOCKBUTTON_SECONDS)!=0; }

  /// set the time format to 24 hour time
  void hourMode(FXbool mode);

  /// is the time set at 24 hour time
  FXbool hourMode() { return (options&CLOCKBUTTON_24HOUR)!=0; }

  /// Show the AM/PM symbol
  void symbol(FXbool mode);

  /// is the AM/PM symbol showing
  FXbool symbol() { return (options&CLOCKBUTTON_SYMBOL)!=0; }

  /// save to stream
  virtual void save(FXStream& store) const;

  /// load from stream
  virtual void load(FXStream& store);

  /// destructor
  virtual ~FXClockButton();
  };

} // namespace FXEX
#endif // FXCLOCKBUTTON_H
