/********************************************************************************
*                                                                               *
*               Fast Mutex (required for threads)                               *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXFASTMUTEX_H
#define FXFASTMUTEX_H

#ifndef FXLOCKABLE_H
#include "FXLockable.h"
#endif
namespace FXEX {

/**
 * A Fast mutex doesn't implement mutex recursion or error checking
 * ie you cant lock it more than once, otherwise it simply blocks
 *    which can sometimes be useful
 *
 * Note: this class doesn't store any internal state, such that,
 *       if you lock it, it is up to you to unlock it.
 */
class FXAPI FXFastMutex : public FXLockable {

private:
  FXThreadMutex mutexHandle;

private:
  // dummy copy constructor and operator= to prevent copying
  FXFastMutex(const FXFastMutex&);
  FXFastMutex& operator=(const FXFastMutex&);

public:
  /// create me a fast mutex :-)
  FXFastMutex();

  /// lock mutex
  void lock();

  /// for a fastlock, trylock fails when we cant lock immediately (ie ms is ignored)
  FXbool trylock(FXuint ms);

  /// release mutex lock
  void unlock();

  /// dtor
  ~FXFastMutex();
  };

} // namespace FXEX
#endif // FXFASTMUTEX_H
