/********************************************************************************
*                                                                               *
*                  Garbage collector object                                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXGARBAGECOLLECTOR_H
#define FXGARBAGECOLLECTOR_H

namespace FXEX {

/**
 * Garbage Collector
 *
 * Assign your dynamically created objects to this object.  It will delete them when
 * it goes out of scope.
 *
 * Idea taken from CGarbage from the DlgEdit program from Martin Welch
 */
class FXAPI FXGarbageCollector {

  private:
    FXArray<FXObject*> objects;
    FXArray<FXStream*> streams;
    FXArray<FXException*> exceptions;

  public:
    /// give me a garbage collector
    FXGarbageCollector() {}

    /// Number of objects in garbage collector
    FXint no() { return objects.no() + streams.no() + exceptions.no(); }

    /// assignment or addition just adds the object to the garbage collector
    void operator= (FXObject *o) { objects.append(o); }
    void operator= (FXStream *s) { streams.append(s); }
    void operator= (FXException *e) { exceptions.append(e); }

    /// assignment or addition just adds the object to the garbage collector
    void operator+= (FXObject *o) { objects.append(o); }
    void operator+= (FXStream *s) { streams.append(s); }
    void operator+= (FXException *e) { exceptions.append(e); }

    /// we just add the object to the garbage collector
    void add(FXObject *o) { objects.append(o); }
    void add(FXStream *s) { streams.append(s); }
    void add(FXException *e) { exceptions.append(e); }

    /// when we destruct, we garbage collect
    ~FXGarbageCollector();
  };

} // namespace FXEX
#endif // FXGARBAGECOLLECTOR_H

