/********************************************************************************
*                                                                               *
*                  HTML event generator object                                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXHTMLPARSER_H
#define FXHTMLPARSER_H

#ifndef FXXMLPARSER_H
#include "FXXmlParser.h"
#endif
namespace FXEX {

/**
 * This is a forst round implementation at generating a HTML parser which in turn
 * creates for events for each recognized HTML keyword.
 *
 * The purpose is to decouple the stream parsing from the storage in memory
 */
class FXAPI FXHtmlParser : public FXXmlParser {
  FXDECLARE(FXHtmlParser)

protected:
  /// for serialization
  FXHtmlParser() : FXXmlParser() {}

public:
  enum {
    ID_HTML_PARSER=FXXmlParser::ID_LAST,
    ID_HTML,
    ID_HEAD,
    ID_BODY,
    ID_TITLE,
    ID_TEXT,
    ID_IMG,
    ID_HREF,
    ID_CENTER,
    ID_TABLE,
    ID_TR,
    ID_TD,
    ID_LAST
    };

public:
  long onComment(FXObject*,FXSelector,void*);
  long onXmlTag(FXObject*,FXSelector,void*);
  long onMetaTag(FXObject*,FXSelector,void*);
  long onTagBegin(FXObject*,FXSelector,void*);
  long onTagEnd(FXObject*,FXSelector,void*);
  long onContent(FXObject*,FXSelector,void*);
  long onHtmlBegin(FXObject*,FXSelector,void*);
  long onHtmlEnd(FXObject*,FXSelector,void*);

public:
  /// create a reader for the incoming stream
  FXHtmlParser(FXApp* a,FXStream* s,FXObject* tgt,FXSelector sel);

  /// cleanup
  virtual ~FXHtmlParser();
  };

} // namespace FXEX
#endif // FXHTMLPARSER_H
