/********************************************************************************
*                                                                               *
*                  IO Stream                                                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXIOSTREAM_H
#define FXIOSTREAM_H

#ifndef FXSTREAM_H
#include <fox/FXStream.h>
using namespace FX;
#endif
namespace FXEX {
class FXIOHandle;

/**
 * IO Stream's are used to read FXStream data from files, sockets, serial ports, etc.
 * eg you can serialise a FOX object to a socket, which is then se-serialised at the other end.
 */
class FXAPI FXIOStream : public FXStream {

  protected:
    FXIOHandle *iohandle;  // handle to actual socket
    FXbool      opened;  // did this stream open the socket

  protected:
    // serialisation
    FXIOStream(){}

    /// save data to socket
    void saveItems(const void* buf,unsigned long n);

    /// load data from socket
    void loadItems(void* buf,unsigned long n);

  public:
    /// Create a socket stream based on a specific socket
    FXIOStream(const FXObject *cont=NULL);

    /// open a socket stream - socket will be opened if not already opened
    FXbool open(FXIOHandle *handle,FXStreamDirection save_or_load);

    /// close a socket stream
    FXbool close();

    /// dtor
    virtual ~FXIOStream();
  };

} // namespace FXEX
#endif // FXIOSTREAM_H
