/********************************************************************************
*                                                                               *
*                  Memory Mapped File Stream                                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXMEMORYMAPPEDSTREAM_H
#define FXMEMORYMAPPEDSTREAM_H

#ifndef FXSTREAM_H
#include "FXStream.h"
#endif
namespace FXEX {

/**
 * Allows you to serailise/deserialise an FXStream from a file which has been memory mapped.
 */
class FXAPI FXMemoryMappedStream : public FXStream {
private:
  FXuchar      *region;   // memory mapped region
  unsigned long space;    // region size
protected:
  virtual void saveItems(const void *buf,unsigned long n);
  virtual void loadItems(void *buf,unsigned long n);

public:
  /// Create stream to bind to memory mapped region of file
  FXMemoryMappedStream(const FXObject* cont=NULL);

  /// Open file store
  FXbool open(void* region,unsigned long size,FXStreamDirection save_or_load);

  /// Close file store
  FXbool close();

  /// Move to position
  virtual FXbool position(unsigned long p);

  /// Save to stream
  virtual FXStream& operator<<(const FXuchar& v);
  virtual FXStream& operator<<(const FXchar& v);

  /// Load from stream
  virtual FXStream& operator>>(FXuchar& v);
  virtual FXStream& operator>>(FXchar& v);

  /// Destructor
  virtual ~FXMemoryMappedStream();
  };

} // namespace FXEX
#endif // FXMEMORYMAPPEDSTREAM_H
