/********************************************************************************
* FXNetworkSelectorEx.h                                                         *
* Copyright (C) 2001 by Dustin Graves. All Rights Reserved.                     *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifdef WIN32
#ifndef FXNETWORKSELECTOREX_H
#define FXNETWORKSELECTOREX_H

#ifndef FXPACKER_H
#include <fox/FXPacker.h>
using namespace FX;
#endif
namespace FXEX {
class FXNetworkListEx;

/**
 * List network shares, using a selector box
 */
class FXAPI FXNetworkSelectorEx : public FXPacker {
  FXDECLARE(FXNetworkSelectorEx)

protected:
  FXLabel         *label;           // Description
  FXNetworkListEx *netbox;          // Network list widget
  FXButton        *accept;          // Accept button
  FXButton        *cancel;          // Cancel button

protected:
  // serialization
  FXNetworkSelectorEx() : FXPacker() {}

private:
  FXNetworkSelectorEx(const FXNetworkSelectorEx&);
  FXNetworkSelectorEx &operator=(const FXNetworkSelectorEx&);

public:
  long onUpdNetList(FXObject*,FXSelector,void*);

public:
  enum {
    ID_NETLIST=FXPacker::ID_LAST,
    ID_LAST
    };

public:
  // ctor
  FXNetworkSelectorEx(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);

  /// returns pointers to those objects
  FXLabel *listLabel() const { return label; }
  FXButton *acceptButton() const { return accept; }
  FXButton *cancelButton() const { return cancel; }
  
  //When called, will relist net neighborhood.  A wait cursor is optional.
  FXbool refreshNetworkList(FXbool waitCursor=FALSE);

  //When called, option to relist net neighborhood.  A wait cursor is optional.
  void showNetworkShares(FXbool show,FXbool refresh=FALSE,FXbool waitCursor=FALSE);
  FXbool showNetworkShares() const;

  /// manipulate the currently selected item
  void setSelection(const FXString& name);
  FXString getSelection() const;

  /// get the 'Network' names
  FXString getNetworkName(const FXString& name) const;
  FXString getSelectionNetworkName() const;

  /// manipulate the style of the Network box
  void setNetBoxStyle(FXuint style);
  FXuint getNetBoxStyle() const;

  /// save to stream
  virtual void save(FXStream& store) const;

  /// load from stream
  virtual void load(FXStream& store);

  /// dtor
  virtual ~FXNetworkSelectorEx();
  };

} // namespace FXEX
#endif // FXNETWORKSELECTOREX_H
#endif

