/********************************************************************************
*                                                                               *
*                   Simulated worker thread object                              *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXNULLTHREAD_H
#define FXNULLTHREAD_H

#ifndef FXRUNNABLE_H
#include "FXRunnable.h"
#endif
namespace FXEX {

/**
 * A null thread implements the thread object API, without using OS threads.
 * The purpose is to allow the developer to develop using a thread-like environment
 * without having to worry about concurrency issues.
 *
 * It also provides a way for threads to be debugged...
 */
class FXAPI FXNullThread : public FXRunnable {
  FXDECLARE_ABSTRACT(FXNullThread)

private:
  FXbool running;
  FXint  idleCount;
  FXuint idle;

protected:
  FXint stopThread;

public:
  enum {
    ID_RUN=FXRunnable::ID_LAST,
    ID_YIELD,
    ID_LAST
    };

public:
  long onThreadRun(FXObject*,FXSelector,void*);
  long onThreadYield(FXObject*,FXSelector,void*);

protected:
  /// This is the ctor you need when you sub-class FXThread
  FXNullThread(FXObject *tgt=NULL,FXSelector sel=0);

  /// sleep
  void sleep(FXint ms=0);

  /// yield the cpu
  void yield();

public:
  /// start running the object - ptr is some data you may want to pass
  void start();

  /// you are meant to overload this in your child thread classes
  /// ...if you have one...
  virtual void run()=0;

  // stop a thread
  void stop() { stopThread++; }

  // is the thread running
  FXbool isRunning();

  // reset the thread
  void reset() { stopThread=0; }

  /// dtor
  virtual ~FXNullThread();
  };

} // namespace FXEX
#endif // FXNULLTHREAD_H
