/* FXTreeEditor ver.0.2.4
 *
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 *
 * $fxtreeeditor: fxtreeeditor.h,v 1.71.0 2001/10/25 10:43:00 Toshihiro Inoue Exp $
 */
#ifndef FXTREEEDITOR_H
#define FXTREEEDITOR_H

#ifndef FXEXTREELIST_H
#include "FXExTreeList.h"
#endif
namespace FXEX {

/**
 * An editor of tree items of specific number visible (huh?)
 */
class FXAPI FXTreeEditor: public FXExTreeList {
  FXDECLARE(FXTreeEditor)

protected:
  FXMenuPane* menu;
  FXString copyString;
  FXString mIndent;

private:
  void initMenu();
  
protected:
  FXTreeEditor(){}
  
public:
  enum {
    ID_APPEND=FXExTreeList::ID_LAST,
    ID_CHILD,
    ID_INSERT,
    ID_DELETE,
    ID_RENAME,
    ID_COPYITEM,
    ID_CUT_SEL,
    ID_COPY_SEL,
    ID_PASTE,
    ID_LAST
    };

public:
  inline FXString getIndent() const { return mIndent; }
  inline void setIndent(const FXString& ind) { mIndent = ind; }
  
public:
  long onEditEnd(FXObject* sender, FXSelector sel, void* ptr);
  long onUpdMenu(FXObject* sender, FXSelector sel, void* ptr);
  long onRightBtnRelease(FXObject* sender, FXSelector sel, void* ptr);
  long onKeyPress(FXObject* sender, FXSelector sel, void* ptr);
  long onCmdItem(FXObject* sender, FXSelector sel, void* ptr);
  long onClipboardRequest(FXObject* sender, FXSelector sel, void* ptr);
  long onCmdCutSel(FXObject* sender, FXSelector sel, void* ptr);
  long onCmdCopySel(FXObject* sender, FXSelector sel, void* ptr);
  long onCmdPaste(FXObject* sender, FXSelector sel, void* ptr);

public:
  /// get an editor of tree items of specific num visible
  FXTreeEditor(FXComposite* p,FXint nvis,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);

  /// create resources
  virtual void create();

  /// set a new tree item
  void setNewItem(FXTreeItem* item);

  /// set the default tree item
  virtual void setDefaultIcon(FXTreeItem* item);

  /// child command
  void cmdChild();

  /// append
  void cmdAppend();

  /// insert
  void cmdInsert();

  /// delete
  void cmdDelete();

  /// rename
  void cmdRename();

  /// copy
  void cmdCopy();

  /// insert an item
  FXTreeItem* insert(const FXString& text, FXTreeItem* next, FXbool sel=TRUE);

  /// put some data from the tree into a stream
  virtual void offerData(FXint type, FXStream* stream, FXTreeItem* item);

  /// get some data out of strean into tree, at a specific parent
  virtual FXTreeItem* acceptData(FXint type, FXuchar* buffer, FXuint size, FXTreeItem* parent, FXTreeItem* prev, FXTreeItem* next);

  /// put some item to the stream
  void toData(FXStream* stream, FXTreeItem* item, const FXString& indent);

  /// take some items from the stream
  FXTreeItem* fromData(FXStream* stream, FXint& indent, FXTreeItem* parent, FXTreeItem* prev, FXTreeItem* next, FXTreeItem* defPrev);
  
  /// dtor
  virtual ~FXTreeEditor();
  };

} // namespace FXEX
#endif // FXTREEEDITOR_H
