/********************************************************************************
*                                                                               *
*                            db text field control                              *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Giancarlo Formicuccia.  All Rights Reserved.            *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXDBTEXTFIELD_H
#define FXDBTEXTFIELD_H

#ifndef FXTEXTFIELD_H
#include <fox/FXTextField.h>
#endif
namespace FXEX {
class FXDatabaseField;
class FXDatabaseQuery;

class FXAPI FXdbTextField: public FXTextField {
  FXDECLARE(FXdbTextField)
private:
  FXbool forceReadOnly;
  FXbool virtuallyEditable;
  FXDatabaseField *dbf;
  FXDatabaseQuery *dbq;
protected:
  FXdbTextField() {}
public:
  enum {
    ID_DBFIELD = FXTextField::ID_LAST,
    ID_LAST
  };
  long onDBField(FXObject *, FXSelector, void *);
public:
  FXdbTextField(FXComposite* p,FXint ncols,FXObject* tgt=NULL,FXSelector sel=0,
    FXuint opts=TEXTFIELD_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,
    FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);
  virtual ~FXdbTextField();
  virtual void create();
  void setEditable(FXbool edit=TRUE);
  void setText(const FXString &text);

  void bindTo(FXDatabaseQuery *dbq, const FXString &col);
  void bindTo(FXDatabaseQuery *dbq, FXint col);
};

}

#endif /* FXDBTEXTFIELD_H */
