/********************************************************************************
*                                                                               *
*                  Clock button settings dialog                                 *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXCheckButton.h>
using namespace FX;
#include "FXClockButton.h"
#include "FXClockDialog.h"
using namespace FXEX;
namespace FXEX {

FXIMPLEMENT(FXClockDialog,FXDialogBox,NULL,0)

FXClockDialog::FXClockDialog(FXWindow* owner,FXClockButton* tgt) : FXDialogBox(owner,"Clock settings", DECOR_TITLE){
  new FXCheckButton(this,"Show &seconds",tgt,FXClockButton::ID_TOGGLE_SECONDS);
  new FXCheckButton(this,"24 &hour mode",tgt,FXClockButton::ID_TOGGLE_HOURMODE);
  new FXCheckButton(this,"AM/&PM symbol is shown",tgt,FXClockButton::ID_TOGGLE_SYMBOL);
  FXButton *button= new FXButton(this, "&Ok", NULL,this,FXDialogBox::ID_ACCEPT, LAYOUT_CENTER_X|FRAME_RAISED|FRAME_THICK, 0,0,0,0 ,20,20,5,5);
  button->setDefault(TRUE);
  }

}

