/********************************************************************************
*                                                                               *
*                  Time/date routines namespace                                 *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXString.h>
using namespace FX;
#include "FXDateTime.h"
using namespace FXEX;
namespace FXEX {

FXTime FXDateTime::now(){
  return (FXTime) ::time(NULL);
  }

// returns a millisecond value, for the current second, suitable for millisecond widgets
FXint FXDateTime::milliseconds(){
#ifndef WIN32
  struct timeval tv;
  if (gettimeofday(&tv,NULL)==0) return (FXint)tv.tv_usec/1000;
  return 0;
#else
  FIXME GetTickCount
#endif
  }

// returns a microsecond value, suitable for measuring execution time
FXlong FXDateTime::microseconds(){
#ifndef WIN32
  struct timeval tv;
  if (gettimeofday(&tv,NULL)==0) return (FXlong)tv.tv_usec + ((FXlong)tv.tv_sec)*1000000;
#else
  FIXME  GetTickCount
#endif
  return 0;
}

FXTime FXDateTime::localtime(FXTime time){
  if (time==0) time=now();
#ifndef WIN32
  return ::mktime( ::localtime( (time_t*)&time ) );
#else
  return now();
#endif
  }

FXTime FXDateTime::gmtime(FXTime time){
  if (time==0) time=now();
#ifndef WIN32
  return ::mktime( ::gmtime( (time_t*)&time ) );
#else
  return now();  //FIXME what is this meant to be on windows
#endif
  }

FXString FXDateTime::convert(FXTime time,const FXString& format,FXbool UTC){
  FXchar buf[512];
  FXint len;
  if (UTC) 
    len= ::strftime(buf,sizeof(buf),format.text(),::gmtime( (time_t*)&time ));
  else 
    len= ::strftime(buf,sizeof(buf),format.text(),::localtime( (time_t*)&time ));
  return FXString(buf,len);
  }

// convert from date string to number since 1970
// Note: if you dont define _XOPEN_SOURCE you dont get it back!
FXTime FXDateTime::convert(const FXString &s,const FXString& format){
#ifdef HAVE_STRPTIME
  struct tm time;
  ::strptime(s.text(),format.text(),&time);
  return (FXTime) ::mktime (&time);
#else
  return (FXTime) -1;
#endif
  }

}

