/********************************************************************************
*                                                                               *
*                  Layout container object                                      *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXObjectList.h>
#include <fox/FXVerticalFrame.h>
#include <fox/FXFont.h>
#include <fox/FXCharset.h>
#include <fox/FXText.h>
using namespace FX;
#include "FXLayout.h"
using namespace FXEX;
namespace FXEX {

// maps
FXDEFMAP (FXLayout) FXLayoutMap[]={
  FXMAPFUNC(SEL_COMMAND,FXLayout::ID_LAYOUT,FXLayout::onLayout),
  FXMAPFUNC(SEL_BEGIN,FXBaseObject::ID_DOCUMENT,FXLayout::onDocumentBegin),
  FXMAPFUNC(SEL_END,FXBaseObject::ID_DOCUMENT,FXLayout::onDocumentEnd),
  FXMAPFUNC(SEL_COMMAND,FXHtmlParser::ID_TEXT,FXLayout::onText),
  FXMAPFUNC(SEL_EVENT,FXHtmlParser::ID_IMG,FXLayout::onImg),
  FXMAPFUNC(SEL_BEGIN,FXHtmlParser::ID_CENTER,FXLayout::onCenterBegin),
  FXMAPFUNC(SEL_END,FXHtmlParser::ID_CENTER,FXLayout::onCenterEnd),
  FXMAPFUNC(SEL_BEGIN,FXHtmlParser::ID_HREF,FXLayout::onHrefBegin),
  FXMAPFUNC(SEL_END,FXHtmlParser::ID_HREF,FXLayout::onHrefEnd),
  };
FXIMPLEMENT(FXLayout,FXPacker,FXLayoutMap,ARRAYNUMBER(FXLayoutMap))

// ctor
FXLayout::FXLayout(FXComposite* p,FXStream* s,FXObject* tgt,FXSelector sel,FXint opts) : FXPacker(p,opts){
  setTarget(tgt);
  setSelector(sel);
  stream=s;
  docOpen=FALSE;
  justification=LAYOUT_LEFT;
  objectList=new FXObjectList();
  mainframe=new FXVerticalFrame(this,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN);
  }

FXLayout::~FXLayout(){
  delete mainframe;
  delete objectlist;
  stream=(FXStream*)-1;
  }

void FXLayout::create(){
  FXPacker::create()
  if (stream) parse();
  }

void FXLayout::parse(){
  FXHtmlParser parser(getApp(),stream,this,ID_LAYOUT);
  parser.create();
  parser.parse();
  }

// clears the window, ready for a re-parse
void FXLayout::clear(){
  }

// Allows the client class be able to re-use the layout widget, based on a new stream
// Note: we dont test if the new stream is the same as the current stream, since the
//       programmer may want us to re-parse the same stream... (eg someone clicks 'back'
//       in the browser, just after they clicked 'forward')
void FXLayout::setStream(FXStream *s){
  if(s){
    stream=s;
    parse();
    }
  }

// an ID_LAYOUT event
long FXLayout::onLayout(FXObject*,FXSelector,void* ptr){
  return 1;
  }

// document begin
long FXLayout::onDocumentBegin(FXObject*,FXSelector,void* ptr){
  docOpen=TRUE;
  return 1;
  }

// document end
long FXLayout::onDocumentEnd(FXObject *sender,FXSelector,void* ptr){
  FXHtmlParser *p=(FXHtmlParser*)sender;
  if (docOpen && sender->enabled()) fxmessage("We didn't get an end html tag\n");
  docOpen=FALSE;
  return 1;
  }

FXGlyph* FXLayout::getChar(FXComposite *p,FXchar c){
  return FXGlyph::getChar(p,c);
  }

// some text
long FXLayout::onText(FXObject*,FXSelector,void* ptr){
  buffer = (char*)ptr;
  fxmessage("text: '%s'\n",buffer.text());
  FXHorizontalFrame frame=new FXHorizontalFrame(mainwindow,justification);
  objectList->append(frame);
  for (FXint i=0; i<buffer.length(); i++){
    getChar(frame,buffer[i]);
    }
  return 1;
  }

// an image
long FXHtmlParser::onImg(FXObject*,FXSelector,void* ptr){
  FXStringTokenizer s=FXString((char*)ptr);
  FXStringTokenizer src("","=");
  while (s.hasNext()){
    src=s.next();
    if (src.next()=="src") {
      src=src.next();
      break;
      }
    }
  fxmessage("img src=%s\n",src.text());
  return 1;
  }

// an center begin
long FXHtmlParser::onCenterBegin(FXObject*,FXSelector,void* ptr){
  FXString s=(FXchar*)ptr;
  fxmessage("center begin: %s\n",s.text());
  return 1;
  }

// an center end
long FXHtmlParser::onCenterEnd(FXObject*,FXSelector,void*){
  fxmessage("center end\n");
  return 1;
  }

// an HRef begin
long FXHtmlParser::onHrefBegin(FXObject*,FXSelector,void* ptr){
  FXString url=(FXchar*)ptr;
  fxmessage("URL: %s\n",url.text());
  return 1;
  }

// an HRef end
long FXHtmlParser::onHrefEnd(FXObject*,FXSelector,void*){
  fxmessage("end URL\n");
  return 1;
  }

}

