/********************************************************************************
* FXNetworkDialogEx.cpp                                                         *
* Copyright (C) 2001 by Dustin Graves. All Rights Reserved.                     *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <config.h>
#ifdef WIN32
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "FXNetworkSelectorEx.h"
#include "FXNetworkDialogEx.h"
using namespace FXEX;
namespace FXEX {


/*******************************************************************************/

FXIMPLEMENT(FXNetworkDialogEx,FXDialogBox,NULL,0)

// ctor
FXNetworkDialogEx::FXNetworkDialogEx(FXWindow* owner,const FXString& name,FXuint opts,FXint x,FXint y,FXint w,FXint h) : FXDialogBox(owner,name,opts|DECOR_TITLE|DECOR_BORDER|DECOR_RESIZE,x,y,w,h,0,0,0,0,4,4) {
  netbox=new FXNetworkSelectorEx(this,NULL,0,LAYOUT_FILL_X|LAYOUT_FILL_Y);
  netbox->acceptButton()->setTarget(this);
  netbox->acceptButton()->setSelector(FXDialogBox::ID_ACCEPT);
  netbox->cancelButton()->setTarget(this);
  netbox->cancelButton()->setSelector(FXDialogBox::ID_CANCEL);
  }

// dtor
FXNetworkDialogEx::~FXNetworkDialogEx() {
  netbox=(FXNetworkSelectorEx*)-1;
  }

// save to stream
void FXNetworkDialogEx::save(FXStream& store) const {
  FXDialogBox::save(store);
  store << netbox;
  }

// load from stream
void FXNetworkDialogEx::load(FXStream& store) {
  FXDialogBox::load(store);
  store >> netbox;   
  }

//When called, will relist net neighborhood.  A wait cursor is optional.
FXbool FXNetworkDialogEx::refreshNetworkList(FXbool waitCursor) {
  return netbox->refreshNetworkList(waitCursor);
  }

//When called, option to relist net neighborhood.  A wait cursor is optional.
void FXNetworkDialogEx::showNetworkShares(FXbool show,FXbool refresh,FXbool waitCursor) {
  netbox->showNetworkShares(show,refresh,waitCursor);
  }

FXbool FXNetworkDialogEx::showNetworkShares() const {
  return netbox->showNetworkShares();
  }

void FXNetworkDialogEx::setSelection(const FXString& name) {
  netbox->setSelection(name);
  }

FXString FXNetworkDialogEx::getSelection() const {
  return netbox->getSelection();
  }

FXString FXNetworkDialogEx::getNetworkName(const FXString& name) const {
  return netbox->getNetworkName(name);
  }

FXString FXNetworkDialogEx::getSelectionNetworkName() const {
  return netbox->getSelectionNetworkName();
  }

void FXNetworkDialogEx::setNetBoxStyle(FXuint style) {
  netbox->setNetBoxStyle(style);
  }

FXuint FXNetworkDialogEx::getNetBoxStyle() const {
  return netbox->getNetBoxStyle();
  }

//Specialized shows for loading net data
void FXNetworkDialogEx::show(FXbool loadnet) {
  FXDialogBox::show();
  if(loadnet) netbox->refreshNetworkList(TRUE);
  }

void FXNetworkDialogEx::show(FXuint placement,FXbool loadnet) {
  FXDialogBox::show(placement);
  if(loadnet) netbox->refreshNetworkList(TRUE);
  }

FXuint FXNetworkDialogEx::execute(FXuint placement,FXbool loadnet) {
  create();
  show(placement);
  if(loadnet) netbox->refreshNetworkList(TRUE);
  return getApp()->runModalFor(this);
  }

}
#endif
