/********************************************************************************
*                                                                               *
*               Dynamically linked FXObject derived loader                      *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXObject.h>
#include <fox/FXWindow.h>
using namespace FX;
#include "exincs.h"
#include "fxexdefs.h"
#include "FXDLL.h"
#include "FXObjectLoader.h"
using namespace FXEX;
namespace FXEX {

// pre-declare 'interesting' object return types
typedef void (*voidtype)();
typedef FXWindow* (*windowtype)(FXComposite*);
typedef FXBaseObject* (*basetype)(FXApp*);
typedef FXObject* (*objecttype)();

// map
FXIMPLEMENT(FXObjectLoader,FXBaseObject,NULL,0)

// serialisation
FXObjectLoader::FXObjectLoader() : FXBaseObject() {
  dll = new FXDLL();
  }

// ctor using generic dll loader
FXObjectLoader::FXObjectLoader(FXApp *a,const FXString& filename) : FXBaseObject(a) {
  dll = new FXDLL(filename);
  }

// ctor using custom dll loader
FXObjectLoader::FXObjectLoader(FXApp *a,FXDLL *d) : FXBaseObject(a) {
  dll=d;
  }

// dtor
FXObjectLoader::~FXObjectLoader(){
  delete dll;
  dll=(FXDLL*)-1;
  }

// create resources
void FXObjectLoader::create() {
  FXBaseObject::create();
  if (!dll->isOpen()) dll->open();
  }

// save resources
void FXObjectLoader::save(FXStream& store) const {
  FXBaseObject::save(store);
  store << dll->getFilename();
  }

// load resources
void FXObjectLoader::load(FXStream& store) {
  FXBaseObject::load(store);
  FXString filename;
  store >> filename;
  if (!dll->isOpen()) {
    dll->setFilename(filename);
    dll->open();
    }
  }

// load an FXWindow derived class
FXWindow* FXObjectLoader::getFXWindow(FXComposite *p){
  windowtype func = (windowtype)dll->getFunction("open");
  if (func==NULL) {
    FXString f=dll->getFilename();
    if (target) target->handle(this,FXSEL(SEL_ERROR,message),(void*)&f);
    return NULL;
    }
  return (*func)(p);
  }

// load an FXBaseObject derived class
FXBaseObject* FXObjectLoader::getFXBaseObject(){
  basetype func = (basetype)dll->getFunction("open");
  if (func==NULL) {
    FXString f=dll->getFilename();
    if (target) target->handle(this,FXSEL(SEL_ERROR,message),(void*)&f);
    return NULL;
    }
  return (*func)(getApp());
  }

// load an FXObject derived class
FXObject* FXObjectLoader::getFXObject(){
  objecttype func = (objecttype)dll->getFunction("open");
  if (func==NULL) {
    FXString f=dll->getFilename();
    if (target) target->handle(this,FXSEL(SEL_ERROR,message),(void*)&f);
    return NULL;
    }
  return (*func)();
  }

}

