/********************************************************************************
*                                                                               *
*                   Base type for thread objects                                *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "fxexdefs.h"
#include "FXArray.h"
#include "FXInterlock.h"
#include "FXThreadManager.h"
#include "FXRunnable.h"
using namespace FXEX;
namespace FXEX {

// maps
FXDEFMAP(FXRunnable) FXRunnableMap[]={
  FXMAPFUNC(SEL_COMMAND,FXRunnable::ID_WAKE,FXRunnable::onWake),
  FXMAPFUNC(SEL_COMMAND,FXRunnable::ID_START,FXRunnable::onStart),
  };
FXIMPLEMENT_ABSTRACT(FXRunnable,FXThreadedObject,FXRunnableMap,ARRAYNUMBER(FXRunnableMap))

// The thread manager knows about all runnable objects 
FXRunnable::FXRunnable(FXObject *tgt,FXSelector sel) : FXThreadedObject(tgt,sel) {
  getThreadManager()->add(this);
  waitlock=new FXInterlock(tgt,sel);
  }

// cleanup resources
FXRunnable::~FXRunnable(){
  delete waitlock;
  getThreadManager()->remove(this);
  }

/// get a handle to the main thread
FXThreadManager* FXRunnable::getThreadManager() {
  return FXThreadManager::instance();
  }

// sleep the current thread
void FXRunnable::sleep(FXint ms){
  if (ms<0) wait();
  else if (ms==0) yield();
  else fxsleep(ms);
  }

// Yield the thread
void FXRunnable::yield() {
  fxsleep(0);
  }

// cause this thread to wait indefinately
void FXRunnable::wait(){
  waitlock->wait();
  }

// wake a thread that is waiting indefinately
void FXRunnable::wake(){
  waitlock->activate();
  }

// wake up
long FXRunnable::onWake(FXObject*,FXSelector,void*){
  wake();
  return 1;
  }

// start thread
long FXRunnable::onStart(FXObject*,FXSelector,void*){
  start();
  return 1;
  }

}

