/********************************************************************************
*                                                                               *
*                  Socket server object                                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "exincs.h"
#include "fxexdefs.h"
#include "FXThreadEvent.h"
#include "FXFastMutex.h"
#include "FXAtomic.h"
#include "FXMutex.h"
#include "FXResolver.h"
#include "FXSocketServer.h"
using namespace FXEX;
namespace FXEX {

// map
FXIMPLEMENT(FXSocketServer,FXSocket,NULL,0)

// server by port
FXSocketServer::FXSocketServer(FXApp* a,FXint port,FXint backLog,FXObject *tgt,FXSelector sel,FXSocketFamily family,FXSocketType type) : FXSocket(a,port,tgt,sel,family,type),backlog(backLog) {}

// server by service
FXSocketServer::FXSocketServer(FXApp* a,const FXString &service,FXint backLog,FXObject *tgt,FXSelector sel,FXSocketFamily family,FXSocketType type) : FXSocket(a,service,tgt,sel,family,type),backlog(backLog) {}

// create listening resources
FXbool FXSocketServer::open(){
  if (status() != FXIOStatusOk || getState()!=FXIOStateNone) return FALSE;
  if (!FXSocket::open()) return FALSE;
  return listen(backlog);
  }

// save resources
void FXSocketServer::save(FXStream& store) const {
  FXSocket::save(store);
  store << backlog;
  }

// load resources
void FXSocketServer::load(FXStream& store){
  FXSocket::load(store);
  store >> backlog;
  }

}

