/********************************************************************************
*                                                                               *
*                       T a b l e   B o x   O b j e c t                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXTableBox.cpp,v 1.15 2001/04/27 14:30:31 jeroen Exp $                   *
*********************************************************************************
* contributor Hakki Dogusan dogusanh@tr.net  http://home.tr.net/dogusanh        *
********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXTextField.h>
#include <fox/FXMenuButton.h>
#include <fox/FXIconList.h>
#include <fox/FXHeader.h>
#include <fox/FXPopup.h>
using namespace FX;
#include "FXTableBox.h"
using namespace FXEX;
namespace FXEX {

/*
  Notes:
  - Handling typed text:
    a) Pass string to target only.
    b) Pass string to target & add to list [begin, after/before current, or end].
    c) Pass string to target & replace current item's label.
  - FXTableBox is a text field which may be filled from an FXList.
  - FXTableBox is a text field which in turn may fill an FXList also.
  - In most other respects, it behaves like a FXTextField.
  - Need to catch up/down arrow keys.
  - Need to have mode to pass item* instead of char*.
  - Combobox turns OFF GUI Updating while being manipulated.
*/

#define TABLEBOX_INS_MASK  (TABLEBOX_REPLACE|TABLEBOX_INSERT_BEFORE|TABLEBOX_INSERT_AFTER|TABLEBOX_INSERT_FIRST|TABLEBOX_INSERT_LAST)
#define TABLEBOX_MASK      (TABLEBOX_STATIC|TABLEBOX_INS_MASK)



/*******************************************************************************/

// Map
FXDEFMAP(FXTableBox) FXTableBoxMap[]={
  FXMAPFUNC(SEL_FOCUS_UP,0,FXTableBox::onFocusUp),
  FXMAPFUNC(SEL_FOCUS_DOWN,0,FXTableBox::onFocusDown),
  FXMAPFUNC(SEL_CHANGED,0,FXTableBox::onChanged),
  FXMAPFUNC(SEL_COMMAND,0,FXTableBox::onCommand),
  FXMAPFUNC(SEL_UPDATE,FXTableBox::ID_TEXT,FXTableBox::onUpdFmText),
  FXMAPFUNC(SEL_CLICKED,FXTableBox::ID_LIST,FXTableBox::onListClicked),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,FXTableBox::ID_TEXT,FXTableBox::onTextButton),
  FXMAPFUNC(SEL_CHANGED,FXTableBox::ID_TEXT,FXTableBox::onTextChanged),
  FXMAPFUNC(SEL_COMMAND,FXTableBox::ID_TEXT,FXTableBox::onTextCommand),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXTableBox::onFwdToText),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETINTVALUE,FXTableBox::onFwdToText),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETREALVALUE,FXTableBox::onFwdToText),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE,FXTableBox::onFwdToText),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETINTVALUE,FXTableBox::onFwdToText),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETREALVALUE,FXTableBox::onFwdToText),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETSTRINGVALUE,FXTableBox::onFwdToText),
  };


// Object implementation
FXIMPLEMENT(FXTableBox,FXPacker,FXTableBoxMap,ARRAYNUMBER(FXTableBoxMap))


// List box
FXTableBox::FXTableBox(FXComposite *p,FXint cols,FXint nvis,FXint bcol,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb):
  FXPacker(p,opts,x,y,w,h, 0,0,0,0, 0,0){
  visible=nvis;
  boundcol=bcol;
  flags|=FLAG_ENABLED;
  target=tgt;
  message=sel;
  text=new FXTextField(this,cols,this,FXTableBox::ID_TEXT,0, 0,0,0,0, pl,pr,pt,pb);
  if(options&TABLEBOX_STATIC) text->setEditable(FALSE);
  pane=new FXPopup(this,FRAME_LINE);
  //hd list=new FXList(pane,nvis,this,FXTableBox::ID_LIST,LIST_BROWSESELECT|LIST_AUTOSELECT|LAYOUT_FILL_X|LAYOUT_FILL_Y|SCROLLERS_TRACK|HSCROLLER_NEVER);
  list=new FXIconList(pane,this,FXTableBox::ID_LIST,ICONLIST_COLUMNS|ICONLIST_SINGLESELECT|ICONLIST_AUTOSIZE|LAYOUT_FILL_X|LAYOUT_FILL_Y|SCROLLERS_TRACK);
  //hd if(options&COMBOBOX_STATIC) list->setScrollStyle(SCROLLERS_TRACK|HSCROLLING_OFF);
  button=new FXMenuButton(this,NULL,NULL,pane,FRAME_RAISED|FRAME_THICK|MENUBUTTON_DOWN|MENUBUTTON_ATTACH_RIGHT, 0,0,0,0, 0,0,0,0);
  button->setXOffset(border);
  button->setYOffset(border);
  flags&=~FLAG_UPDATE;  // Never GUI update
  }


// Createwindow
void FXTableBox::create(){
  FXPacker::create();
  pane->create();
  }


// Detach window
void FXTableBox::detach(){
  FXPacker::detach();
  pane->detach();
  }


// Destroy window
void FXTableBox::destroy(){
  pane->destroy();
  FXPacker::destroy();
  }


// Enable the window
void FXTableBox::enable(){
  if(!(flags&FLAG_ENABLED)){
    FXPacker::enable();
    text->enable();
    button->enable();
    }
  }


// Disable the window
void FXTableBox::disable(){
  if(flags&FLAG_ENABLED){
    FXPacker::disable();
    text->disable();
    button->disable();
    }
  }


// Get default width
FXint FXTableBox::getDefaultWidth(){
  FXint ww,pw;
  ww=text->getDefaultWidth()+button->getDefaultWidth()+(border<<1);
  pw=0; //hd pane->getDefaultWidth();
  return FXMAX(ww,pw);
  }


// Get default height
FXint FXTableBox::getDefaultHeight(){
  FXint th,bh;
  th=text->getDefaultHeight();
  bh=button->getDefaultHeight();
  return FXMAX(th,bh)+(border<<1);
  }


// Recalculate layout
void FXTableBox::layout(){
  FXint buttonWidth,textWidth,itemHeight;
  itemHeight=height-(border<<1);
  buttonWidth=button->getDefaultWidth();
  textWidth=width-buttonWidth-(border<<1);
  text->position(border,border,textWidth,itemHeight);
  button->position(border+textWidth,border,buttonWidth,itemHeight);
  //hd pane->resize(width,pane->getDefaultHeight());
  FXint tableWidth=(border<<1);
  for(FXint i=0; i<getNumHeaders(); ++i) tableWidth+=getHeaderSize(i);
  pane->resize(FXMAX(width,tableWidth), height*visible);
  flags&=~FLAG_DIRTY;
  }


// Forward GUI update of text field to target; but only if pane is not popped
long FXTableBox::onUpdFmText(FXObject*,FXSelector,void*){
  return target && !pane->shown() && target->handle(this,FXSEL(SEL_UPDATE,message),NULL);
  }


// Command handled in the text field
long FXTableBox::onFwdToText(FXObject* sender,FXSelector sel,void* ptr){
  return text->handle(sender,sel,ptr);
  }


// Changed
long FXTableBox::onChanged(FXObject*,FXSelector,void* ptr){
  if(target) target->handle(this,FXSEL(SEL_CHANGED,message),ptr);
  return 1;
  }


// Command
long FXTableBox::onCommand(FXObject*,FXSelector,void* ptr){
  if(target) target->handle(this,FXSEL(SEL_COMMAND,message),ptr);
  return 1;
  }


// Forward clicked message from list to target
long FXTableBox::onListClicked(FXObject*,FXSelector,void* ptr){
  button->handle(this,FXSEL(SEL_COMMAND,ID_UNPOST),NULL);    // Unpost the list
  if(0<=((FXint)(long)ptr)){
    //hd FXString string=list->getItemText((FXint)(long)ptr);
    FXString string=getItemColText((FXint)(long)ptr);
    text->setText(string); //hd
    handle(this,FXSEL(SEL_COMMAND,0),(void*)string.text());
    }
  return 1;
  }


// Pressed left button in text field
long FXTableBox::onTextButton(FXObject*,FXSelector,void*){
  if(options&TABLEBOX_STATIC){
    button->handle(this,FXSEL(SEL_COMMAND,ID_POST),NULL);    // Post the list
    return 1;
    }
  return 0;
  }


// Text has changed
long FXTableBox::onTextChanged(FXObject*,FXSelector,void* ptr){
  handle(this,FXSEL(SEL_CHANGED,0),ptr);
  return 1;
  }


// Text has changed
long FXTableBox::onTextCommand(FXObject*,FXSelector,void* ptr){
  /*hd
  FXint index=list->getCurrentItem();
  if(!(options&TABLEBOX_STATIC)){
    switch(options&TABLEBOX_INS_MASK){
      case TABLEBOX_REPLACE:
        if(0<=index) replaceItem(index,(FXchar*)ptr);
        break;
      case TABLEBOX_INSERT_BEFORE:
        if(0<=index) insertItem(index,(FXchar*)ptr);
        break;
      case TABLEBOX_INSERT_AFTER:
        if(0<=index) insertItem(index+1,(FXchar*)ptr);
        break;
      case TABLEBOX_INSERT_FIRST:
        insertItem(0,(FXchar*)ptr);
        break;
      case TABLEBOX_INSERT_LAST:
        appendItem((FXchar*)ptr);
        break;
      }
    }
  */
  handle(this,FXSEL(SEL_COMMAND,0),ptr);
  return 1;
  }


// Select upper item
long FXTableBox::onFocusUp(FXObject*,FXSelector,void*){
  FXint index=getCurrentItem();
  if(index<0) index=getNumRows()-1;
  else if(0<index) index--;
  if(0<=index && index<getNumRows()){
    setCurrentItem(index);
    handle(this,FXSEL(SEL_COMMAND,0),(void*)list->getItemText(index).text());
    }
  return 1;
  }


// Select lower item
long FXTableBox::onFocusDown(FXObject*,FXSelector,void*){
  FXint index=getCurrentItem();
  if(index<0) index=0;
  else if(index<getNumRows()-1) index++;
  if(0<=index && index<getNumRows()){
    setCurrentItem(index);
    handle(this,FXSEL(SEL_COMMAND,0),(void*)list->getItemText(index).text());
    }
  return 1;
  }


// Return true if editable
FXbool FXTableBox::isEditable() const {
  return text->isEditable();
  }


// Set widget is editable or not
void FXTableBox::setEditable(FXbool edit){
  text->setEditable(edit);
  }


// Set text
void FXTableBox::setText(const FXString& txt){
  text->setText(txt);
  }


// Obtain text
FXString FXTableBox::getText() const {
  return text->getText();
  }


// Set number of text columns
void FXTableBox::setTextNumCols(FXint cols){
  text->setNumColumns(cols);
  }


// Get number of text columns
FXint FXTableBox::getTextNumCols() const {
  return text->getNumColumns();
  }


// Get number of visible items
FXint FXTableBox::getNumVisible() const {
  return visible;
  }


// Set number of visible items
void FXTableBox::setNumVisible(FXint nvis){
  if(nvis<0) nvis=0;
  if(visible!=nvis){
    visible=nvis;
    recalc();
    }
  }


// Set font
void FXTableBox::setFont(FXFont* fnt){
  if(!fnt){ fxerror("%s::setFont: NULL font specified.\n",getClassName()); }
  text->setFont(fnt);
  list->setFont(fnt);
  recalc();
  }


// Obtain font
FXFont* FXTableBox::getFont() const {
  return text->getFont();
  }


// Set window background color
void FXTableBox::setBackColor(FXColor clr){
  text->setBackColor(clr);
  list->setBackColor(clr);
  }


// Get background color
FXColor FXTableBox::getBackColor() const {
  return text->getBackColor();
  }


// Set text color
void FXTableBox::setTextColor(FXColor clr){
  text->setTextColor(clr);
  list->setTextColor(clr);
  }


// Return text color
FXColor FXTableBox::getTextColor() const {
  return text->getTextColor();
  }


// Set select background color
void FXTableBox::setSelBackColor(FXColor clr){
  text->setSelBackColor(clr);
  list->setSelBackColor(clr);
  }


// Return selected background color
FXColor FXTableBox::getSelBackColor() const {
  return text->getSelBackColor();
  }


// Set selected text color
void FXTableBox::setSelTextColor(FXColor clr){
  text->setSelTextColor(clr);
  list->setSelTextColor(clr);
  }


// Return selected text color
FXColor FXTableBox::getSelTextColor() const {
  return text->getSelTextColor();
  }


// Set help text
void FXTableBox::setHelpText(const FXString& txt){
  text->setHelpText(txt);
  }

// Get help text
FXString FXTableBox::getHelpText() const {
  return text->getHelpText();
  }


// Set tip text
void FXTableBox::setTipText(const FXString& txt){
  text->setTipText(txt);
  }


// Get tip text
FXString FXTableBox::getTipText() const {
  return text->getTipText();
  }

//hd--------------------------------------------------------------------------
/// Return the bound column
FXint FXTableBox::getBoundCol() const {
  return boundcol;
  }

/// Set the bound column
void FXTableBox::setBoundCol(FXint bcol) {
  boundcol=bcol;
  }

/// Return number of rows
FXint FXTableBox::getNumRows() const {
  return list->getNumRows();
  }

/// Return number of list columns
FXint FXTableBox::getNumCols() const {
  return list->getNumCols();
  }

/// Return header control
FXHeader* FXTableBox::getHeader() const {
  return list->getHeader();
  }

/// Append header with given text and optional icon
void FXTableBox::appendHeader(const FXString& text,FXIcon *icon,FXint size) {
  list->appendHeader(text,icon,size);
  }

/// Remove header at index
void FXTableBox::removeHeader(FXint index) {
  list->removeHeader(index);
  }

/// Change text of header at index
void FXTableBox::setHeaderText(FXint index,const FXString& text){
  list->setHeaderText(index,text);
  }

/// Return text of header at index
FXString FXTableBox::getHeaderText(FXint index) const {
  return list->getHeaderText(index);
  }

/// Change icon of header at index
void FXTableBox::setHeaderIcon(FXint index,FXIcon *icon){
  list->setHeaderIcon(index,icon);
  }

/// Return icon of header at index
FXIcon* FXTableBox::getHeaderIcon(FXint index) const {
  return list->getHeaderIcon(index);
  }

/// Change size of header at index
void FXTableBox::setHeaderSize(FXint index,FXint size){
  list->setHeaderSize(index,size);
  }

/// Return width of header at index
FXint FXTableBox::getHeaderSize(FXint index) const {
  return list->getHeaderSize(index);
  }

/// Return number of headers
FXint FXTableBox::getNumHeaders() const {
  return list->getNumHeaders();
  }

/// Return the item at the given index
FXIconItem *FXTableBox::getItem(FXint index) const {
  return list->getItem(index);
  }
/*
FXString FXTableBox::getItem(FXint index) const {
  return list->getItem(index)->getText();
  }
*/


/// Replace the item with a [possibly subclassed] item
FXint FXTableBox::setItem(FXint index,FXIconItem* item) {
  return list->setItem(index,item);
  }
/*
void FXTableBox::setItem(FXint index,const FXString& text,void* ptr){
  list->setItem(index,text,NULL,ptr);
  recalc();
  }
*/


/// Replace items text, icons, and user-data pointer
FXint FXTableBox::setItem(FXint index,const FXString& text,FXIcon *big,FXIcon* mini,void* ptr) {
  return list->setItem(index,text,big,mini,ptr);
  }

/// Insert a new [possibly subclassed] item at the give index
FXint FXTableBox::insertItem(FXint index,FXIconItem* item){
  return list->insertItem(index,item);
  }
/*
void FXTableBox::insertItem(FXint index,const FXString& text,void* ptr){
  //hd list->insertItem(index,text,NULL,ptr);
  //hd recalc();
  }
*/


/// Insert item at index with given text, icons, and user-data pointer
FXint FXTableBox::insertItem(FXint index,const FXString& text,FXIcon *big,FXIcon* mini,void* ptr) {
  return list->insertItem(index,text,big,mini,ptr);
  }

/// Append a [possibly subclassed] item to the end of the list
FXint FXTableBox::appendItem(FXIconItem* item){
  return list->appendItem(item);
  }
/*
void FXTableBox::appendItem(const FXString& text,void* ptr){
  list->appendItem(text,NULL,ptr);
  recalc();
  }
*/


/// Append new item with given text and optional icons, and user-data pointer
FXint FXTableBox::appendItem(const FXString& text,FXIcon *big,FXIcon* mini,void* ptr){
  return list->appendItem(text,big,mini,ptr);
  }

/// Append a [possibly subclassed] item to the end of the list
FXint FXTableBox::prependItem(FXIconItem* item){
  return list->prependItem(item);
  }
/*
void FXTableBox::prependItem(const FXString& text,void* ptr){
  list->prependItem(text,NULL,ptr);
  recalc();
  }
*/


/// Append new item with given text and optional icons, and user-data pointer
FXint FXTableBox::prependItem(const FXString& text,FXIcon *big,FXIcon* mini,void* ptr) {
  return list->prependItem(text,big,mini,ptr);
  }

/// Remove item from list
void FXTableBox::removeItem(FXint index){
  list->removeItem(index);
  }
/*
void FXTableBox::removeItem(FXint index){
  FXint current;
  list->removeItem(index);
  current=list->getCurrentItem();
  if(0<=current){
    setText(list->getItemText(current));
    }
  else{
    setText("");
    }
  recalc();
  }
*/


/// Remove all items from list
void FXTableBox::clearItems(){
  list->clearItems();
  }
/*
void FXTableBox::clearItems(){
  list->clearItems();
  setText("");
  recalc();
  }
*/


/// Return item width
FXint FXTableBox::getItemWidth() const {
  return list->getItemWidth();
  }

/// Return item height
FXint FXTableBox::getItemHeight() const {
  return list->getItemHeight();
  }

/// Return index of item at x,y, or -1 if none
//hd FXint getItemAt(FXint x,FXint y) const;
//  return list->getItemAt(x,y);
//  }

/**
* Search items for item by name, starting from start item; the
* flags argument controls the search direction, and case sensitivity.
*/
FXint FXTableBox::findItem(const FXString& text,FXint start,FXuint flags) const {
  return list->findItem(text,start,flags);
  }

/// Scroll to make item at index visible
void FXTableBox::makeItemVisible(FXint index){
  list->makeItemVisible(index);
  }

/// Change item text
void FXTableBox::setItemText(FXint index,const FXString& txt) {
  if(isItemCurrent(index)) {
    text->setText(txt.section('\t',boundcol));
    }
  list->setItemText(index,txt);
  recalc();
  }
/*
void FXTableBox::setItemText(FXint index,const FXString& txt){
  if(isItemCurrent(index)) setText(txt);
  list->setItemText(index,txt);
  recalc();
  }
*/


/// Change item's column text; col==-1=>use boundcol
void FXTableBox::setItemColText(FXint index,const FXString& txt,FXint col){
  if(col==-1)col=boundcol;
  FXString cs=list->getItemText(index);
  FXString ns="";
  FXString t=txt;
  if(col==0){
    ns=t.append('\t').append(cs.after('\t',1));
    }
  else{
    ns=cs.before('\t',col).append('\t').append(t).append('\t').append(cs.after('\t',col+1));
    }
  list->setItemText(index,ns);
  }


/// Return item text
FXString FXTableBox::getItemText(FXint index) const {
  return list->getItemText(index);
  }


/// Return item's column text; col==-1=> use boundcol
FXString FXTableBox::getItemColText(FXint index,FXint col) const {
  if(col==-1)col=boundcol;
  FXString s=list->getItemText(index);
  return s.section('\t',col);
  }


/// Change item big icon
void FXTableBox::setItemBigIcon(FXint index,FXIcon* icon) {
  list->setItemBigIcon(index,icon);
  }

/// Return big icon of item at index
FXIcon* FXTableBox::getItemBigIcon(FXint index) const {
  return list->getItemBigIcon(index);
  }

/// Change item mini icon
void FXTableBox::setItemMiniIcon(FXint index,FXIcon* icon){
  list->setItemMiniIcon(index,icon);
  }

/// Return mini icon of item at index
FXIcon* FXTableBox::getItemMiniIcon(FXint index) const {
  return list->getItemMiniIcon(index);
  }

/// Change item user-data pointer
void FXTableBox::setItemData(FXint index,void* ptr) {
  list->setItemData(index,ptr);
  }
/*
void FXTableBox::setItemData(FXint index,void* ptr) const {
  list->setItemData(index,ptr);
  }
*/


/// Return item user-data pointer
void* FXTableBox::getItemData(FXint index) const {
  return list->getItemData(index);
  }
/*
void* FXTableBox::getItemData(FXint index) const {
  return list->getItemData(index);
  }
*/


/// Return TRUE if item at index is selected
FXbool FXTableBox::isItemSelected(FXint index) const {
  return list->isItemSelected(index);
  }

/// Return TRUE if item at index is current
FXbool FXTableBox::isItemCurrent(FXint index) const {
   return list->isItemCurrent(index);
   }
/*
FXbool FXTableBox::isItemCurrent(FXint index) const {
  return list->isItemCurrent(index);
  }
*/


/// Return TRUE if item at index is visible
FXbool FXTableBox::isItemVisible(FXint index) const {
  return list->isItemVisible(index);
  }

/// Return TRUE if item at index is enabled
FXbool FXTableBox::isItemEnabled(FXint index) const {
  return list->isItemEnabled(index);
  }

/// Return item hit code: 0 outside, 1 icon, 2 text
FXint FXTableBox::hitItem(FXint index,FXint x,FXint y,FXint ww,FXint hh) const {
  return list->hitItem(index,x,y,ww,hh);
  }

/// Repaint item at index
void FXTableBox::updateItem(FXint index) {
  list->updateItem(index);
  }

/// Select items in rectangle
FXbool FXTableBox::selectInRectangle(FXint x,FXint y,FXint w,FXint h){
  return list->selectInRectangle(x,y,w,h);
  }

/// Enable item at index
FXbool FXTableBox::enableItem(FXint index) {
  return list->enableItem(index);
  }

/// Disable item at index
FXbool FXTableBox::disableItem(FXint index){
  return disableItem(index);
  }

/// Select item at index
FXbool FXTableBox::selectItem(FXint index){
  return list->selectItem(index);
  }

/// Deselect item at index
FXbool FXTableBox::deselectItem(FXint index){
  return list->deselectItem(index);
  }

/// Toggle item at index
FXbool FXTableBox::toggleItem(FXint index){
  return list->toggleItem(index);
  }

/// Change current item index
void FXTableBox::setCurrentItem(FXint index){
  list->setCurrentItem(index);
  if(0<=index){
    FXString s=list->getItemText(index);
    text->setText(s.section('\t',boundcol));
    }
  else{
    text->setText("");
    }
  }
/*
void FXComboBox::setCurrentItem(FXint index){
  list->setCurrentItem(index);
  if(0<=index){
    setText(list->getItemText(index));
    }
  else{
    setText("");
    }
  }
*/


/// Return current item index, or -1 if none
FXint FXTableBox::getCurrentItem() const {
  return list->getCurrentItem();
  }
/*
FXint FXTableBox::getCurrentItem() const {
  return list->getCurrentItem();
  }
*/


/// Change anchor item index
void FXTableBox::setAnchorItem(FXint index) {
  list->setAnchorItem(index);
  }

/// Return anchor item index, or -1 if none
FXint FXTableBox::getAnchorItem() const {
  return list->getAnchorItem();
  }

/// Return index of item under cursor, or -1 if none
FXint FXTableBox::getCursorItem() const {
  return list->getCursorItem();
  }

/// Extend selection from anchor index to index
FXbool FXTableBox::extendSelection(FXint index){
  return list->extendSelection(index);
  }

/// Deselect all items
FXbool FXTableBox::killSelection(){
  return list->killSelection();
  }

/// Sort items
void FXTableBox::sortItems(){
  list->sortItems();
  }

/// Change text font
//hd void setFont(FXFont* fnt);
//void FXIconListBox::setFont(FXFont* fnt){
//  if(!fnt){ fxerror("%s::setFont: NULL font specified.\n",getClassName()); }
//  field->setFont(fnt);
//  list->setFont(fnt);
//  recalc();
//  }

/// Return text font
//hd FXFont* getFont() const;
//FXFont* FXIconListBox::getFont() const { //{ return font; }
//  return field->getFont();
//  }

/// Return normal text color
//hd FXColor getTextColor() const;
//FXColor FXIconListBox::getTextColor() const { //{ return textColor; }
//  return field->getTextColor();
//  }

/// Change normal text color
//hd void setTextColor(FXColor clr);
//void FXIconListBox::setTextColor(FXColor clr){
//  field->setTextColor(clr);
//  list->setTextColor(clr);
//  }

/// Return selected text background
//hd FXColor getSelBackColor() const;
//FXColor FXIconListBox::getSelBackColor() const {
//  return list->getSelBackColor();
//  }

/// Change selected text background
//hd void setSelBackColor(FXColor clr);
//void FXIconListBox::setSelBackColor(FXColor clr) {
//  list->setSelBackColor(clr);
//  }

/// Return selected text color
//hd FXColor getSelTextColor() const;
//FXColor FXIconListBox::getSelTextColor() const {
//  return list->getSelTextColor();
//  }

/// Change selected text color
//hd void setSelTextColor(FXColor clr);
//void FXIconListBox::setSelTextColor(FXColor clr) {
//  list->setSelTextColor(clr);
//  }

/// Change maximum item space for each item
void FXTableBox::setItemSpace(FXint s) {
  list->setItemSpace(s);
  }

/// Return maximum item space
FXint FXTableBox::getItemSpace() const {
  return list->getItemSpace();
  }

/// Return sort function
FXIconListSortFunc FXTableBox::getSortFunc() const {
  return list->getSortFunc();
  }

/// Change sort function
void FXTableBox::setSortFunc(FXIconListSortFunc func){
  list->setSortFunc(func);
  }

/// Get the current icon list style
FXuint FXTableBox::getListStyle() const {
  return (options&TABLEBOX_MASK);
  }
// Get combobox style
FXuint FXTableBox::getComboStyle() const {
  return (options&TABLEBOX_MASK);
  }



/// Set the current icon list style.
void FXTableBox::setListStyle(FXuint mode){
  FXuint opts=(options&~TABLEBOX_MASK)|(mode&TABLEBOX_MASK);
  if(opts!=options){
    options=opts;
    recalc();
    }
  }
// Change combobox style
void FXTableBox::setComboStyle(FXuint mode){
  FXuint opts=(options&~TABLEBOX_MASK)|(mode&TABLEBOX_MASK);
  if(opts!=options){
    options=opts;
    if(options&TABLEBOX_STATIC){
      text->setEditable(FALSE);                                 // Non-editable
      list->setScrollStyle(SCROLLERS_TRACK|HSCROLLING_OFF);     // No scrolling
      }
    else{
      text->setEditable(TRUE);                                  // Editable
      list->setScrollStyle(SCROLLERS_TRACK|HSCROLLER_NEVER);    // Scrollable, but no scrollbar
      }
    recalc();
    }
  }
//hd--------------------------------------------------------------------------


// Save object to stream
void FXTableBox::save(FXStream& store) const {
  FXPacker::save(store);
  store << text;
  store << button;
  store << list;
  store << pane;
  }


// Load object from stream
void FXTableBox::load(FXStream& store){
  FXPacker::load(store);
  store >> text;
  store >> button;
  store >> list;
  store >> pane;
  }


// Delete it
FXTableBox::~FXTableBox(){
  delete pane;
  pane=(FXPopup*)-1;
  text=(FXTextField*)-1;
  button=(FXMenuButton*)-1;
  list=(FXIconList*)-1;
  }

}
