/********************************************************************************
*                                                                               *
*               Waitable object base type                                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXString.h>
#include <fox/FXStream.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "fxexdefs.h"
#include "FXWaitable.h"
using namespace FXEX;
namespace FXEX {

// map
FXDEFMAP(FXWaitable) FXWaitableMap[]={
  FXMAPFUNC(SEL_COMMAND,FXWaitable::ID_ACTIVATE,FXWaitable::onActivate),
  FXMAPFUNC(SEL_COMMAND,FXWaitable::ID_ACTIVATE_ALL,FXWaitable::onActivateAll),
  };
FXIMPLEMENT_ABSTRACT(FXWaitable,FXThreadedObject,FXWaitableMap,ARRAYNUMBER(FXWaitableMap))

// ctor
FXWaitable::FXWaitable(FXObject *tgt,FXSelector sel) : FXThreadedObject(tgt,sel) {}

// dtor
FXWaitable::~FXWaitable() {}

// wait indefinately
void FXWaitable::wait(){
  signal(SEL_WAITABLE_WAIT);
  }

// timed wait for this base class returns true
FXbool FXWaitable::trywait(FXuint ms){
  signal(SEL_WAITABLE_WAIT);
  return TRUE;
  }

// activate implements nothing... it just signals the main thread
void FXWaitable::activate(){
  signal(SEL_WAITABLE_ACTIVATE);
  }

// implement default broadcast mechanism
void FXWaitable::activateAll(){
  signal(SEL_WAITABLE_ACTIVATE);  // FIXME need to implement SEL_ACTIVATE_ALL all mechanism
  }

// handle GUI calling activate
long FXWaitable::onActivate(FXObject*,FXSelector,void*){
  activate();
  return 1;
  }

// handle GUI calling activateAll
long FXWaitable::onActivateAll(FXObject*,FXSelector,void*){
  activateAll();
  return 1;
  }

}

