/*******************************************************************************
* Copyright (C) 2001,2002 by H. J. Daniel III. All Rights Reserved.            *
********************************************************************************
* This library is free software; you can redistribute it and/or                *
* modify it under the terms of the GNU Lesser General Public                   *
* License as published by the Free Software Foundation; either                 *
* version 2.1 of the License, or (at your option) any later version.           *
*                                                                              *
* This library is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU            *
* Lesser General Public License for more details.                              *
*                                                                              *
* You should have received a copy of the GNU Lesser General Public             *
* License along with this library; if not, write to the Free Software          *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.   *
*******************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/fxkeys.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXButton.h>
#include <fox/FXSeparator.h>
#include <fox/FXImageFrame.h>
using namespace FX;
#include "FXArray.h"
#include "FXWizardDialog.h"
#include "FXWizardPage.h"
using namespace FXEX;
namespace FXEX {

//****************************************************************************/
// FXWizardPage
//****************************************************************************/
FXDEFMAP(FXWizardPage) FXWizardPageMap[]= {
  FXMAPFUNC(SEL_COMMAND, FXWizardPage::ID_WIZARDPAGE_CHANGED, FXWizardPage::onPageChanged),
  FXMAPFUNC(SEL_COMMAND, FXWizardPage::ID_WIZARDPAGE_CHANGING, FXWizardPage::onPageChanging),
  FXMAPFUNC(SEL_COMMAND, FXWizardDialog::ID_WIZARD_CANCEL, FXWizardPage::onPageCancel),
  FXMAPFUNC(SEL_COMMAND, FXWizardDialog::ID_WIZARD_HELP, FXWizardPage::onPageHelp),
  FXMAPFUNC(SEL_FOCUS_NEXT,0,FXWizardPage::onFocusNext),
  //FXMAPFUNC(SEL_FOCUSIN,0,FXWizardPage::onFocusIn),
  };
FXIMPLEMENT(FXWizardPage,FXPacker,FXWizardPageMap,ARRAYNUMBER(FXWizardPageMap))

FXWizardPage::FXWizardPage(FXWizardDialog* wizard,FXImage* image,FXWizardPage *prev,FXWizardPage *next,FXuint opts):FXPacker(wizard,opts|LAYOUT_EXPLICIT) {
  wizard->pageArray.append(this);

  // wizard does it's own padding
  setPadTop(0);
  setPadBottom(0);
  setPadLeft(0);
  setPadRight(0);

  _next = next;
  _prev = prev;
  _pageImage = image;
  _wizard = wizard;

  // initially the page is hidden, it's shown only when it becomes current
  // initially disable the page from focus support from control navigation
  hide();
  disableFocus();
  }

//Only allow focus on the page that is current
long FXWizardPage::onFocusNext(FXObject* sender,FXSelector sel ,void* ptr) {
  FXTRACE((1,"onFocusNext Was Sent\n"));
  if(canFocus()) return(FXPacker::onFocusNext(sender,sel,ptr));
  return 0;
  }

//Child windows created by wizard pages should return focus to the wizard
long FXWizardPage::onFocusIn(FXObject* sender,FXSelector sel ,void* ptr) {
  FXTRACE((1,"onFocusIn Was Sent\n"));
  return(FXPacker::onFocusIn(sender,sel,ptr));
  }

}

