/*
 *  FXBroadcastTest.h
 *  foxtest
 *
 *  Created by Zed Shaw on Wed Sep 11 2002.
 *  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
 *
 */



// MyTestSuite.h
#include <cxxtest/TestSuite.h>
#include "FXBroadcast.h"
#include <fox/fx.h>

class FXBroadcastTest : public CxxTest::TestSuite
{
public:

  FXBroadcast *broadcast;
  FXDebugTarget *debugger;

  void setUp() {
    broadcast = new FXBroadcast();
    debugger = new FXDebugTarget();
    broadcast->append(new FXDebugTarget());
    broadcast->append(new FXDebugTarget());
    broadcast->append(new FXDebugTarget());
  }

  void tearDown() {
    delete broadcast;
    delete debugger;
  }

  
  void test_append( void ) {
    // make sure that there is actually three elements
    TS_ASSERT_EQUALS(broadcast->no(), 4);
  }

  void test_handle( void ) {
    // make sure we at least have three to work with
    TS_ASSERT(broadcast->no() >= 3);
    
    for(int i = 0; i < 10; i++) {
      TS_ASSERT_EQUALS(broadcast->handle(debugger, MKUINT(i, i), NULL), 1);
    }
  }

};
