/* FXSpriteCanvas Test ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas-test: mycanvas.h,v 1.34.0 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#ifndef _MYCANVAS_H_
#define _MYCANVAS_H_

class MyLine;

#include <fxspritecanvas.h>
#include <fxspritebox.h>
#include <fxspriteboxtext.h>
#include <fxspritepolygon.h>
#include <fxspritearctext.h>


class MyCanvas: public FXSpriteCanvas
{
public:
  FXDECLARE(MyCanvas)

public:
  enum {
    ID_LABELEDIT = FXSpriteCanvas::ID_LAST,
    ID_LAST
  };
  
public:
  MyCanvas(FXComposite* p, FXObject* tgt = NULL, FXSelector sel = 0, FXuint opts = FRAME_NORMAL, FXint x = 0, FXint y = 0, FXint w = 0, FXint h = 0);
  void adjustLines();
  virtual void moveArea(FXdouble x, FXdouble y);
  long onLeftPress(FXObject* sender, FXSelector sel, void* ptr);
  long onLeftRelease(FXObject* sender, FXSelector sel, void* ptr);
  long onMiddlePress(FXObject* sender, FXSelector sel, void* ptr);
  long onMiddleRelease(FXObject* sender, FXSelector sel, void* ptr);
  long onRightPress(FXObject* sender, FXSelector sel, void* ptr);
  long onRightRelease(FXObject* sender, FXSelector sel, void* ptr);
  long onMouseMove(FXObject* sender, FXSelector sel, void* ptr);
  long onEditHide(FXObject* sender, FXSelector sel, void* ptr);
  long onEditKeyPress(FXObject* sender, FXSelector sel, void* ptr);
  long onEditChanged(FXObject* sender, FXSelector sel, void* ptr);
  
protected:
  MyCanvas();
  
private:
  void __init_class__();
  
private:
  FXSpritePoint cpt;
  FXint cx;
  FXint cy;
  FXSpriteObject* item;
  FXdouble ix;
  FXdouble iy;
  FXint mButton;
  MyLine* mLine;
  FXbool flgMove;
  FXTextField* labelEdit;
  FXSpriteObject* target;
  FXSpriteBox* selBox;
};

#endif // _MYCANVAS_H_
