/* FXSpriteCanvas Test ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas-test: mywin.cpp,v 1.45.4 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#include "mywin.h"

#include "mycanvas.h"

#include <fxspriteimage.h>

FXDEFMAP(MyWin) MyWinMap[] = {
  FXMAPFUNC(SEL_COMMAND, MyWin::ID_TRI  , MyWin::onCmdTri  ),
  FXMAPFUNC(SEL_COMMAND, MyWin::ID_RECT , MyWin::onCmdRect ),
  FXMAPFUNC(SEL_COMMAND, MyWin::ID_CIRC , MyWin::onCmdCirc ),
  FXMAPFUNC(SEL_COMMAND, MyWin::ID_IMAGE, MyWin::onCmdImage),
};

FXIMPLEMENT(MyWin, FXMainWindow, MyWinMap, ARRAYNUMBER(MyWinMap))

#include "xpms.h"


void MyWin::__init_class__()
{
  layer = 0;
  lyrBtn = 0;
  frmCvs = 0;
  canvas = 0;
  mx = 0;
  my = 0;
  { for(int __0 = 0; __0 < 18; __0++) {
    images[__0] = 0;
  } }
  status = 0;
}


MyWin::MyWin(FXApp* app): FXMainWindow(app, "Test", NULL, NULL, DECOR_ALL, 30, 30, 300, 300)
{
  FXint i = 0;
  FXint j = 0;
  
  __init_class__();
  
  status = new FXStatusbar(this, LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);
  layer  = new FXVerticalFrame(this, LAYOUT_FILL_X|LAYOUT_FILL_Y);
  lyrBtn = new FXHorizontalFrame(layer, LAYOUT_FILL_X);
  new FXButton(lyrBtn, "Triangle" , NULL, this, ID_TRI  , FRAME_RAISED|FRAME_THICK);
  new FXButton(lyrBtn, "Rectangle", NULL, this, ID_RECT , FRAME_RAISED|FRAME_THICK);
  new FXButton(lyrBtn, "Circle"   , NULL, this, ID_CIRC , FRAME_RAISED|FRAME_THICK);
  new FXButton(lyrBtn, "Image"    , NULL, this, ID_IMAGE, FRAME_RAISED|FRAME_THICK);
  frmCvs = new FXVerticalFrame(layer, FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
  canvas = new MyCanvas(frmCvs, NULL, 0, LAYOUT_FILL_X|LAYOUT_FILL_Y);
  canvas->setInterval(150);
  
  mx = my = 10;
  
  const char** xpms[] = {
    /* 0*/ kukuri_f_xpm,
    /* 1*/ kukuri_f2_xpm,
    /* 2*/ kukuri_turn_b_xpm,
    /* 3*/ kukuri_turn_br_xpm,
    /* 4*/ kukuri_turn_f_xpm,
    /* 5*/ kukuri_turn_fr_xpm,
    /* 6*/ kukuri_turn_r_xpm,
    /* 7*/ kukuri_turn_r2_xpm,
    /* 8*/ kukuri_bye_1_xpm,
    /* 9*/ kukuri_bye_2_xpm,
    /*10*/ kukuri_bye_3_xpm,
    /*11*/ kukuri_bye_4_xpm,
    /*12*/ cat_xpm,
    /*13*/ cat2_xpm
  };
  for(i = 0; i < 14; i++) {
    images[i] = new FXXPMIcon(getApp(), xpms[i]);
    images[i]->create();
  }
  const char** xpmsM[] = {
    /* 0*/ kukuri_f2_xpm,
    /* 1*/ kukuri_turn_fr_xpm,
    /* 2*/ kukuri_turn_r_xpm,
    /* 3*/ kukuri_turn_br_xpm
  };
  for(i = 0; i < 4; i++) {
    images[i + 14] = new FXXPMIcon(getApp(), xpmsM[i]);
    images[i + 14]->mirror(TRUE, FALSE);
    images[i + 14]->create();
  }
  
  FXint imgsrc[][16] = {
    { 0, 1, 0, 14, -1 },
    { 4, 15, 16, 17, 2, 3, 6, 5, -1 },
    { 8, 9, 10, 11, 10, 11, 10, 11, 10, 9, -1 },
    { 12, 13, -1 }
  };
  for(i = 0; i < 4; i++) {
    for(j = 0; imgsrc[i][j] != -1; j++) {
      lstImage[i] += images[imgsrc[i][j]];
    }
  }
}


MyWin::MyWin()
{
  __init_class__();
  
}


MyWin::~MyWin()
{
  for(FXint i = 0; i < 18; i++) {
    delete images[i];
  }
}


void MyWin::create()
{
  FXMainWindow::create();
  canvas->create();
  canvas->setArea(0, 0, 2200, 1600);
  show(PLACEMENT_SCREEN);
}


long MyWin::onCmdTri(FXObject* sender, FXSelector sel, void* ptr)
{
  FXdouble x = 0;
  FXdouble y = 0;
  FXSpritePolygon* p = 0;
  
  FXSpritePoint pts[] = {
    {15,  0},
    { 0, 30},
    {30, 30}
  };
  x = canvas->getAreaX() + mx;
  y = canvas->getAreaY() + my;
  p = new FXSpritePolygon(canvas->getDefaultLayer(), x , y, pts, 3);
  p->setForeground(FXRGB(255, 0, 0));
  p->setZ(y + p->getHeight());
  canvas->draw();
  movePoint();
  return 1;
}


long MyWin::onCmdRect(FXObject* sender, FXSelector sel, void* ptr)
{
  FXdouble x = 0;
  FXdouble y = 0;
  FXSpriteBoxText* p = 0;
  
  x = canvas->getAreaX() + mx;
  y = canvas->getAreaY() + my;
  p = new FXSpriteBoxText(canvas->getDefaultLayer(), x, y, 50, 50);
  p->setForeground(FXRGB(0, 255, 0));
  p->setText("Rectangle");
  p->setZ(y + p->getHeight());
  canvas->draw();
  movePoint();
  return 1;
}


long MyWin::onCmdCirc(FXObject* sender, FXSelector sel, void* ptr)
{
  FXdouble x = 0;
  FXdouble y = 0;
  FXSpriteArcText* at = 0;
  
  x = canvas->getAreaX() + mx;
  y = canvas->getAreaY() + my;
  at = new FXSpriteArcText(canvas->getDefaultLayer(), x, y, 50, 50);
  at->setForeground(FXRGB(0, 0, 255));
  at->setText("Circle");
  at->setTextColor(FXRGB(255, 255, 255));
  at->setZ(y + at->getHeight());
  canvas->draw();
  movePoint();
  return 1;
}


long MyWin::onCmdImage(FXObject* sender, FXSelector sel, void* ptr)
{
  FXdouble x = 0;
  FXdouble y = 0;
  FXSpriteImage* i = 0;
  static FXint n(0);
  
  x = canvas->getAreaX() + mx;
  y = canvas->getAreaY() + my;
  i = new FXSpriteImage(canvas->getDefaultLayer(), x, y);
  i->setImages(lstImage[n]);
  if(n == 0) {
    i->setInterval(2);
  } else if(n == 1) {
    i->setInterval(1);
  } else if(n == 2) {
    i->setInterval(3);
  } else {
    i->setInterval(6);
  }
  i->setImageNum(0);
  i->setForeground(FXRGB(192, 192, 0));
  i->setZ(y + i->getHeight());
  canvas->draw();
  movePoint();
  n++;
  if(n > 3) n = 0;
  return 1;
}


void MyWin::movePoint()
{
  mx += 10;
  my += 10;
  
  if(mx > canvas->getWidth() - 50 || my > canvas->getHeight() - 50) {
    mx = my = 10;
  }
}


void MyWin::setStatus(const FXString& t)
{
  status->getStatusline()->setNormalText(t);
}
