/***************************************************************************
                               fxdbtest.cpp
                             -------------------
    copyright            : (C) 2003 by Giancarlo Formicuccia
    email                : ilsensine@inwind.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * Sample application using FXDatabase objects
 */

#include "fxex.h"
#include "queryresult.h"
#include "tables.h"
#include "dbobjects.h"

class MainWindow: public FXMainWindow {
  FXDECLARE(MainWindow);
private:
  FXVerticalFrame *MainFrame;
    FXMatrix *mDB;
      FXLabel *lDB;
      FXTextField *tDB;
      FXLabel *lUser;
      FXTextField *tUser;
      FXLabel *lPwd;
      FXTextField *tPwd;
      FXLabel *lQuery;
      FXTextField *tQuery;
    FXHorizontalFrame *fCmd;
      FXButton *bTables;
      FXButton *bQuery;
      FXButton *bNav;
protected:
  MainWindow() {}
public:
  MainWindow(FXApp *app);
  virtual void create();
  enum {
    ID_ITABLES  = FXMainWindow::ID_LAST,
    ID_IQUERY,
    ID_INAV,
    ID_LAST
    };
  long onTables(FXObject *, FXSelector, void *);
  long onQuery(FXObject *, FXSelector, void *);
  long onNav(FXObject *, FXSelector, void *);
  };

FXDEFMAP(MainWindow) MainWindowMap[] = {
  FXMAPFUNC(SEL_COMMAND, MainWindow::ID_ITABLES, MainWindow::onTables),
  FXMAPFUNC(SEL_COMMAND, MainWindow::ID_IQUERY,  MainWindow::onQuery),
  FXMAPFUNC(SEL_COMMAND, MainWindow::ID_INAV,    MainWindow::onNav)
  };
FXIMPLEMENT(MainWindow, FXMainWindow, MainWindowMap, ARRAYNUMBER(MainWindowMap));


MainWindow::MainWindow(FXApp *app): FXMainWindow(app, "FXDatabase test") {
  MainFrame = new FXVerticalFrame(this, LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    mDB = new FXMatrix(MainFrame, 2, MATRIX_BY_COLUMNS|LAYOUT_FILL_X);
      lDB = new FXLabel(mDB, "Database");
      tDB = new FXTextField(mDB, 64, NULL, 0, TEXTFIELD_NORMAL|LAYOUT_FILL_X|LAYOUT_FILL_COLUMN);
      lUser = new FXLabel(mDB, "User name");
      tUser = new FXTextField(mDB, 64, NULL, 0, TEXTFIELD_NORMAL|LAYOUT_FILL_X|LAYOUT_FILL_COLUMN);
      lPwd = new FXLabel(mDB, "Password");
      tPwd = new FXTextField(mDB, 64, NULL, 0, TEXTFIELD_NORMAL|LAYOUT_FILL_X|LAYOUT_FILL_COLUMN);
      lQuery = new FXLabel(mDB, "Query");
      tQuery = new FXTextField(mDB, 64, NULL, 0, TEXTFIELD_NORMAL|LAYOUT_FILL_X|LAYOUT_FILL_COLUMN);
    fCmd = new FXHorizontalFrame(MainFrame, LAYOUT_FILL_X);
      bTables = new FXButton(fCmd, "Show tables", NULL, this, ID_ITABLES, LAYOUT_FILL_X|BUTTON_NORMAL);
      bQuery = new FXButton(fCmd, "Execute query", NULL, this, ID_IQUERY, LAYOUT_FILL_X|BUTTON_NORMAL);
      bNav = new FXButton(fCmd, "Navigator", NULL, this, ID_INAV, LAYOUT_FILL_X|BUTTON_NORMAL);
}

void MainWindow::create() {
  FXMainWindow::create();
  tDB->setText("Set your data source here");
  tUser->setText("Set your username here");
  tPwd->setText("Set your password here");
  tQuery->setText("Place your query here");
  show(PLACEMENT_SCREEN);
  }

long MainWindow::onTables(FXObject *, FXSelector, void *) {
  FXDatabaseInterface *db;
  db = FXDatabaseManager::getSource("ODBC");
  try {
    db->setDatabase(tDB->getText());
    db->setUser(tUser->getText());
    db->setPassword(tPwd->getText());
    db->connect();
    FXTablesForm tForm(this, db->getTables());
    tForm.execute(PLACEMENT_SCREEN);
  } catch(const FXDatabaseException &e) {
    FXMessageBox::error(this, MBOX_OK, "Error", "%s", e.what());
  }
  FXDatabaseManager::deleteSource(&db);
  return 1;
}

long MainWindow::onQuery(FXObject *, FXSelector, void *) {
  FXDatabaseInterface *db;
  FXDatabaseQuery *hQ;
  db = FXDatabaseManager::getSource("ODBC");
  if(!db) return 1;
  try {
    db->setDatabase(tDB->getText());
    db->setUser(tUser->getText());
    db->setPassword(tPwd->getText());
    db->connect(TRUE);
    hQ = db->createQuery();
    hQ->Open(tQuery->getText(), TRUE);
    FXQueryForm queryForm(this, hQ);
    queryForm.execute(PLACEMENT_SCREEN);
    hQ->Free();
  } catch(const FXDatabaseException &e) {
    FXMessageBox::error(this, MBOX_OK, "Error", "%s", e.what());
  }
  FXDatabaseManager::deleteSource(&db);
  return 1;
}

long MainWindow::onNav(FXObject *, FXSelector, void *) {
  FXDatabaseInterface *db;
  FXDatabaseQuery *hQ;
  db = FXDatabaseManager::getSource("ODBC");
  if(!db) return 1;
  try {
    db->setDatabase(tDB->getText());
    db->setUser(tUser->getText());
    db->setPassword(tPwd->getText());
    db->connect();
    hQ = db->createQuery();
    hQ->Open(tQuery->getText(), FALSE);
    FXNavigatorForm navForm(this, hQ);
    navForm.execute(PLACEMENT_SCREEN);
    hQ->Free();
  } catch(const FXDatabaseException &e) {
    FXMessageBox::error(this, MBOX_OK, "Error", "%s", e.what());
  }
  FXDatabaseManager::deleteSource(&db);
  return 1;
}


// start the ball rolling
int main(int argc, char *argv[]) {
  FXApp app("FXDatabase Test", "FoxExTest");
  app.init(argc, argv);
  fxTraceLevel = 21;
  new MainWindow(&app);
  app.create();
  return app.run();
  }
