#include <fox/fx.h>
#include "fxex.h"

class MyMainWin : public FXMainWindow {
  FXDECLARE(MyMainWin)
protected:
  FXTextField * current;
  FXExplorer * explorer;
protected:
  MyMainWin() {}
public:
  enum {
    ID_EXPLORER = FXMainWindow::ID_LAST,
    ID_ADD,
    ID_REMOVE,
    ID_LAST
  };
public:
  long onOpenedExplorer(FXObject *, FXSelector, void *);
  long onCmdAdd(FXObject *, FXSelector, void *);
  long onUpdAdd(FXObject *, FXSelector, void *);
  long onCmdRemove(FXObject *, FXSelector, void *);
  long onUpdRemove(FXObject *, FXSelector, void *);
public:
  MyMainWin(FXApp * app);
  virtual void create();
  };

// Map
FXDEFMAP(MyMainWin) MyMainWinMap[]={
  FXMAPFUNC(SEL_OPENED,MyMainWin::ID_EXPLORER,MyMainWin::onOpenedExplorer),
  FXMAPFUNC(SEL_COMMAND,MyMainWin::ID_ADD,MyMainWin::onCmdAdd),
  FXMAPFUNC(SEL_UPDATE,MyMainWin::ID_ADD,MyMainWin::onUpdAdd),
  FXMAPFUNC(SEL_COMMAND,MyMainWin::ID_REMOVE,MyMainWin::onCmdRemove),
  FXMAPFUNC(SEL_UPDATE,MyMainWin::ID_REMOVE,MyMainWin::onUpdRemove),
  };
FXIMPLEMENT(MyMainWin, FXMainWindow, MyMainWinMap, ARRAYNUMBER(MyMainWinMap))

MyMainWin::MyMainWin(FXApp * app) : FXMainWindow(app, "FXExplorer", NULL, NULL, DECOR_ALL, 0, 0, 500, 400) {
  FXHorizontalFrame * hFrame = new FXHorizontalFrame(this, FRAME_GROOVE|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  FXVerticalFrame * vFrame = new FXVerticalFrame(hFrame, LAYOUT_FILL_X|LAYOUT_FILL_Y);
  new FXLabel(vFrame, "Same as FXDirList", NULL, LAYOUT_CENTER_X);
  new FXExplorer(vFrame, 0, NULL, 0, FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y|TREELIST_SHOWS_LINES|TREELIST_SHOWS_BOXES);
  new FXVerticalSeparator(hFrame, SEPARATOR_GROOVE|LAYOUT_FILL_Y);
  vFrame = new FXVerticalFrame(hFrame, LAYOUT_FILL_X|LAYOUT_FILL_Y);
  new FXLabel(vFrame, "With option EXPLORER_USER_ROOTS", NULL, LAYOUT_CENTER_X);
  hFrame = new FXHorizontalFrame(vFrame, FRAME_GROOVE|FRAME_THICK|LAYOUT_BOTTOM|LAYOUT_FILL_X);
  current = new FXTextField(hFrame, 0, NULL, 0, FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X);
  new FXButton(hFrame, "Add", NULL, this, ID_ADD, BUTTON_NORMAL|BUTTON_AUTOGRAY);
  new FXButton(hFrame, "Remove", NULL, this, ID_REMOVE, BUTTON_NORMAL|BUTTON_AUTOGRAY);
  explorer = new FXExplorer(vFrame, 0, this, ID_EXPLORER, FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y|EXPLORER_USER_ROOTS/*|EXPLORER_SHOWHIDDEN*/|TREELIST_SHOWS_LINES|TREELIST_SHOWS_BOXES|TREELIST_ROOT_BOXES);
  }

void MyMainWin::create() {
  FXMainWindow::create();
#ifndef WIN32
  explorer->addRoot(getenv("HOME"));
#else
  explorer->addRoot("c:\\");
#endif // WIN32
  show(PLACEMENT_SCREEN);
  }

long MyMainWin::onOpenedExplorer(FXObject * sender, FXSelector, void *) {
  current->setText(explorer->getCurrentFile());
  return 1;
  }

long MyMainWin::onCmdAdd(FXObject * sender, FXSelector, void *) {
  explorer->addRoot(current->getText());
  return 1;
  }

long MyMainWin::onUpdAdd(FXObject * sender, FXSelector sel, void * ptr) {
  return onUpdYes(sender, sel, ptr);
  return FXFile::isDirectory(explorer->getCurrentFile()) ? onUpdYes(sender, sel, ptr) : 0;
  }

long MyMainWin::onCmdRemove(FXObject * sender, FXSelector, void *) {
  explorer->removeRoot(explorer->getCurrentFile());
  return 1;
  }

long MyMainWin::onUpdRemove(FXObject * sender, FXSelector sel, void * ptr) {
  return ((explorer->getCurrentItem()) && (!explorer->getCurrentItem()->getParent())) ?  onUpdYes(sender, sel, ptr) : 0;
  }

int main(int argc, char ** argv) {
  FXApp app("FXExplorer", "pini");
  app.init(argc, argv);
  new MyMainWin(&app);
  app.create();
  return app.run();
  }

