/********************************************************************************
*                                                                               *
*                  Child process object/interface                               *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifdef WIN32

// FIXME I have no idea where this class came from

#ifndef FXPROCESS_H
#define FXPROCESS_H

#include "FXBaseObject.h"
namespace FXEX {

/* implements communication between child process
 * 
 * Generates:
  SEL_INPUT    sent when input can be feed (???)
  SEL_OUTPUT   sent when output is available (ptr = FXString*)
  SEL_ERROR    sent when error is available (ptr = FXString*)
  SEL_END      sent on process termination
*/

class FXAPI FXProcess : public FXBaseObject {
  FXDECLARE(FXProcess)

public:
  enum {
    CAPTURE_NONE,               // Capture nothing
    CAPTURE_INPUT,              // Capture only standard input
    CAPTURE_OUTPUT,             // Capture only standard output
    CAPTURE_INPUT_OUTPUT,       // Capture input and output
    CAPTURE_INPUT_OUTPUTERROR,  // Capture input and merged output+error
    CAPTURE_INPUT_OUTPUT_ERROR  // Capture all
  };

public:
  struct DataBuffer {
    char* buffer;
    int buffer_length;
    };

  struct InputData {
    InputData* next;
    int buffer_length;
    char buffer[1];
    };

protected:
  FXint    captureMode;
  FXbool   running;

#ifdef WIN32
  FXInputHandle ithread, othread, ethread;
  FXInputHandle ihnd,ohnd,ehnd,phnd;
  FXInputHandle outAvailEvent, outEatenEvent;
  FXInputHandle errAvailEvent, errEatenEvent;
  FXInputHandle inAvailEvent;
#endif

protected:
  FXProcess() {};

  int popen(const char *cmdstring);

public:
  DataBuffer output, error;

  InputData* input_list_first;
  InputData* input_list_last;
  void free_all_input_data();

  long onTerminate(FXObject*,FXSelector,void*);
  long onOutput(FXObject*,FXSelector,void*);
  long onError(FXObject*,FXSelector,void*);

  int outputThreadHandler();
  int errorThreadHandler();
  int inputThreadHandler();

public:
  enum {
    ID_PROCESS=FXBaseObject::ID_LAST,
    ID_OUTPUT,
    ID_ERROR,
    ID_INPUT
    ID_LAST
  };

public:

  /** 
   * Create a process object, but do not start it. 
   */
  FXProcess(FXApp* a, FXObject* tgt,FXSelector sel);

  /// Return current capture mode
  FXint getCaptureMode() const { return captureMode; }
 
  /// Set the Capture Mode for next 'execute' call.
  void setCaptureMode(FXint mode) { captureMode=mode; }

  /**
   * Execute the 'program' and pass the 'arguments'
   * Return 'true' if the process started, 'false' on error.
   */
  FXbool execute(FXString& cmdstring);

  /// Test if process is running.
  FXbool isRunning() const { return running; };

  /**
   *  Test if process is still running ?
   *  Return 'true' if the process terminated correctly.
   */
  FXbool terminate(FXint code);

  /// Get PID of last started process
  FXint  processId() const { return (FXint)phnd; }

  void feedInput(const char* str, int len);

  /// destructor
  virtual ~FXProcess();
  };

}; // namespace FXEX

#endif // FXPROCESS
#endif

