/*
  Monitors the registry for any change.  If a change occurs,
  it generates an ID_REGISTRY_UPDATE which widgets should catch.
  FIXME: still to do: load(),save()
*/
 
#ifndef FXREGISTRYMONITOR_H
#define FXREGISTRYMONITOR_H

#include <fox/fx.h>

class FXAPI FXRegistryMonitor : public FXBaseObject {
  FXDECLARE(FXRegistryMonitor)

protected:
  FXTimer    *scanTimer;
  FXint       scanRate;
  FXint       objectCounter;
  FXRegistry *registry;
  FXDict     *objectList;

protected:
  FXRegistryMonitor () {}

public:
  enum {
    ID_TIMER=FXBaseObject::ID_LAST,
    ID_LAST
    };

public:
  long onTimeout(FXObject*,FXSelector,void*);
  long onRegistryModified(FXObject*,FXSelector,void*);

public:
  ///
  FXRegistryMonitor (FXApp* a,FXObject* tgt=NULL,FXSelector sel=0);

  /// create resources
  virtual void create();

  /// has the registry changed
  FXbool regHasChanged();

  /// add registry aware object
  void addObject(FXObject* o);

  /// remove registry aware object
  void removeObject(FXObject* o);

  /// dtor
  ~FXRegistryMonitor ();
  };

#endif // FXREGISTRYMONITOR_H

