/* FXSpriteCanvas ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas: fxspritecanvas.h,v 1.121.0 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#ifndef FXSPRITECANVAS_H
#define FXSPRITECANVAS_H

#include <fox/fx.h>
#include <ffclist.h>

class FXSpriteLayer;
class FXSpriteObject;

typedef struct { FXdouble x,y; } FXSpritePoint;
typedef struct { FXdouble x,y,w,h; } FXSpriteRectangle;


class FXAPI FXSpriteCanvas: public FXScrollArea {
  FXDECLARE(FXSpriteCanvas)
  
protected:
  FXSpriteLayer* defLayer;
  FFCList lstRedraw;
  FXImage* buffer;
  FXbool flgCreate;
  FXint interval;
  FXColor foreground;
  FXColor background;
  FXdouble areaLeft;
  FXdouble areaTop;
  FXdouble areaWidth;
  FXdouble areaHeight;
  FXdouble areaX;
  FXdouble areaY;
  FXint contentWidth;
  FXint contentHeight;
  FXTimer *timer;
  
private:
  void draw(FXDC* pen, FXSpriteRectangle* r, const FXSpritePoint& ps, const FXSpritePoint& pe, FXint w, FXint h);

protected:
  FXSpriteCanvas(){}
  
public:
  enum {
    ID_TIMER=FXMainWindow::ID_LAST,
    ID_LAST
    };

public:
  inline FXSpriteLayer* getDefaultLayer() { return defLayer; }
  inline FXColor getForeground() const { return foreground; }
  inline FXColor getBackground() const { return background; }
  inline void setForeground(FXColor c) { foreground = c; }
  inline void setBackground(FXColor c) { background = c; }

public:
  long onPaint(FXObject* sender, FXSelector sel, void* ptr);
  long onTimer(FXObject* sender, FXSelector sel, void* ptr);
  long onMouseMove(FXObject* sender, FXSelector sel, void* ptr);
  
public:
  FXSpriteCanvas(FXComposite* p, FXObject* tgt = NULL, FXSelector sel = 0, FXuint opts = FRAME_NORMAL, FXint x = 0, FXint y = 0, FXint w = 0, FXint h = 0);

  /// create resources
  virtual void create();

  /// detach resources
  virtual void detach();

  /// delete FXSprite rectangle (why is this here?)
  static void delRect(void*& p);

  /// define the area of the sprite canvas
  void setArea(FXdouble x, FXdouble y, FXdouble w, FXdouble h);

  /// check the area of the canvas
  void checkArea(FXdouble* x, FXdouble* y);

  /// move the area of the canvas
  virtual void moveArea(FXdouble x, FXdouble y);

  /// move the contents of the canvas
  virtual void moveContents(FXint x, FXint y);

  /// the area to the left of the canvas
  FXdouble getAreaLeft() const { return areaLeft; }

  /// the area to the top of the canvas
  FXdouble getAreaTop() const { return areaTop; }

  /// the width of the canvas
  FXdouble getAreaWidth() const { return areaWidth; }

  /// the height of the canvas
  FXdouble getAreaHeight() const { return areaHeight; }

  /// the X distance of the canvas
  FXdouble getAreaX() const { return areaX; }

  /// the Y distance of the canvas
  FXdouble getAreaY() const { return areaY; }

  /// the content width
  virtual FXint getContentWidth() { return contentWidth; }

  /// the content height
  virtual FXint getContentHeight() { return contentHeight; }

  /// draw the contents
  void draw();

  /// redraw the contents
  void redraw(FXdouble x, FXdouble y, FXdouble w, FXdouble h);

  /// which sprite is at x,y
  FXSpriteObject* check(FXint x, FXint y);

  /// is point in list
  void check(FFCList* list, FXint x, FXint y);

  /// convert map co-ordinates (x,y) to canvas co-ordinates (FXSpritePoint)
  FXSpritePoint mapToCanvas(FXint x, FXint y) const;

  /// convert map co-ordinates (FXPoint) to canvas co-ordinates (FXSpritePoint)
  FXSpritePoint mapToCanvas(const FXPoint& pt) const;

  /// convert co-ordinates (x,y) to screen co-ordinates (FXPoint)
  FXPoint mapToScreen(FXdouble x,FXdouble y) const;

  /// convert co-ordinates (FXSpritePoint) to screen co-ordinates (FXPoint)
  FXPoint mapToScreen(const FXSpritePoint& pt) const;

  /// set some interval
  void setInterval(FXint iv);

  /// get some interval
  FXint getInterval() const { return interval; }

  /// dtor
  virtual ~FXSpriteCanvas();
};

#endif // FXSPRITECANVAS_H

