/* FXSpriteCanvas ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas: fxspriteimage.cpp,v 1.44.0 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#include "FXSpriteImage.h"
#include "FXSpriteLayer.h"

FXDEFMAP(FXSpriteImage) FXSpriteImageMap[] = {
  FXMAPFUNC(SEL_TIMEOUT, 0, FXSpriteImage::onTimer),
  };
FXIMPLEMENT(FXSpriteImage, FXSpriteObject, FXSpriteImageMap, ARRAYNUMBER(FXSpriteImageMap))

FXSpriteImage::FXSpriteImage(FXSpriteLayer* layer, FXdouble x /*= 0*/, FXdouble y /*= 0*/): FXSpriteObject(layer, x, y) {
  mImage = NULL;
  mNow = 0;
  interval = 0;
  mCount = 0;
  }

void FXSpriteImage::draw(FXDC* dc, FXdouble x, FXdouble y) {
  FXSpriteObject::draw(dc, x, y);
  dc->drawIcon(mImage, FXint(x), FXint(y));
  }

void FXSpriteImage::setImage(FXIcon* img) {
  redraw();
  images.erase();
  mNow   = 0;
  mCount = 0;
  flgTimer = FALSE;
  mImage = img;
  redraw();
  }

void FXSpriteImage::setImages(const FFCList& img) {
  redraw();
  images = img;
  mCount = 0;
  if(images.length() < 2 || interval < 1) flgTimer = FALSE;
  else flgTimer = TRUE;
  setImageNum(0);
  }

void FXSpriteImage::setImageNum(FXint n) {
  redraw();
  mNow = n;
  if(n < images.length()) mImage = (FXIcon*)images[n];
  else mImage = NULL;
  mW = mImage->getWidth();
  mH = mImage->getHeight();
  redraw();
  }

long FXSpriteImage::onTimer(FXObject* sender, FXSelector sel, void* ptr) {
  if(images.length() < 2 || interval < 1) return 0;
  mCount++;
  if(mCount < interval) return 0;
  mCount = 0;
  mNow++;
  if(mNow >= images.length()) mNow = 0;
  setImageNum(mNow);
  return 1;
  }

void FXSpriteImage::setInterval(FXint iv) {
  mCount = 0;
  interval = iv;
  if(images.length() < 2) flgTimer = FALSE;
  else flgTimer = TRUE;
  }

