/* FXSpriteCanvas ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas: fxspriteobject.h,v 1.109.2 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#ifndef FXSPRITEOBJECT_H
#define FXSPRITEOBJECT_H

#include <fox/fx.h>
#include "FXSpriteCanvas.h"

class FXSpriteLayer;


class FXAPI FXSpriteObject: public FXId {
  FXDECLARE(FXSpriteObject)

protected:
  FXSpriteLayer* mLayer;     // the layer the sprite is sitting on
  FXObject* target;          // application target
  FXSelector message;        // application selector
  FXdouble mX;               // x
  FXdouble mY;               // y
  FXdouble mZ;               // depth
  FXdouble mW;               // width
  FXdouble mH;               // height
  FXdouble absX;             // absolute x
  FXdouble absY;             // absolute y
  FXdouble absZ;             // absolute depth
  FXFont* mFont;             // font of sprite
  FXbool mShown;             // are we shown
  void* data;                // some generic data
  FXColor foreground;        // foreground color of object
  FXColor background;        // background color of object
  FXColor mTextColor;        // text color
  FXString mText;            // text string
  FXint lineWidth;           // line width of sprite
  FXFunction function;       // DC function
  FXLineStyle lineStyle;     // Line style 
  FXCapStyle capStyle;       // Line end cap style
  FXJoinStyle joinStyle;     // Join style

protected:
  FXSpriteObject(){}
  
public:
  FXbool flgRedraw;
  FXbool flgTimer;
  
public:
  inline FXdouble getX() const { return mX; }
  inline FXdouble getY() const { return mY; }
  inline FXdouble getZ() const { return mZ; }
  inline FXdouble getWidth() const { return mW; }
  inline FXdouble getHeight() const { return mH; }
  inline FXdouble getAbsX() const { return absX; }
  inline FXdouble getAbsY() const { return absY; }
  inline FXdouble getAbsZ() const { return absZ; }
  inline FXFont* getFont() const { return mFont; }
  inline FXbool shown() const { return mShown; }
  
public:
  /// generic sprite object
  FXSpriteObject(FXSpriteLayer* layer,FXdouble x=0,FXdouble y=0,FXdouble w=0,FXdouble h=0);

  /// generic draw mechanism
  virtual void draw(FXDC* dc, FXdouble x, FXdouble y);

  /// generic redraw mechanism
  virtual void redraw();

  /// set target
  void setTarget(FXObject* t) { target=t; }

  /// get target
  FXObject* getTarget() const { return target; }

  /// set selector
  void setSelector(FXSelector sel) { message=sel; }

  /// get selector
  FXSelector getSelector() { const return message; }

  /// move sprite to x,y
  virtual void move(FXdouble x, FXdouble y);

  /// move sprite to FXSpritePoint
  void move(const FXSpritePoint& pt) { move(pt.x,pt.y); }

  /// set the Z
  void setZ(FXdouble z);

  /// get the sprite rectangle
  virtual FXSpriteRectangle getRect() const;

  /// get the sprite location (top,left)
  FXSpritePoint getPoint() const;

  /// resize sprite size
  virtual void resize(FXdouble w, FXdouble h);

  /// set the ending point of the sprite (x,y)
  void setEndPoint(FXdouble x, FXdouble y);
  
  /// set the ending point of the sprite (FXSpritePoint)
  void setEndPoint(const FXSpritePoint& pt);

  /// adjust sprite
  virtual void adjust() {}

  /// recalc absolution position
  void recalcAbsPos();

  /// show sprite
  void show();

  /// hide sprite
  void hide();

  /// check if x,y is in sprite
  virtual FXbool check(FXdouble x, FXdouble y);

  /// check if area is in sprite
  virtual FXbool check(FXdouble x, FXdouble y, FXdouble w, FXdouble h);

  /// get some data
  void* getData() const { return data; }

  /// set some data
  void setData(void* d) { data=d; }

  /// get sprite text
  FXString getText() const { return mText; }

  /// set sprite text
  void setText(const FXString& t);

  /// get DC function
  FXFunction getFunction() const { return function; }

  /// set DC function
  void setFunction(FXFunction fnc) { function=fnc; }

  /// get the line width of the sprite
  FXint getLineWidth() const { return lineWidth; }

  /// set the line width
  void setLineWidth(FXint lw);

  /// get the line style
  FXLineStyle getLineStyle() const { return lineStyle; }

  /// set the line style
  void setLineStyle(FXLineStyle st);

  /// get the end cap style
  FXCapStyle getCapStyle() const { return capStyle; }
  
  /// set the end cap style
  void setCapStyle(FXCapStyle st);

  /// get the line join style
  FXJoinStyle getJoinStyle() const { return joinStyle; }

  /// set the line join style
  void setJoinStyle(FXJoinStyle st);

  /// get foreground color
  FXColor getForeground() const { return foreground; }

  /// set foregrund color
  void setForeground(FXColor fore);

  /// get background color
  FXColor getBackground() const { return background; }

  /// set background color
  void setBackground(FXColor back);

  /// get text color
  FXColor getTextColor() const { return mTextColor; }
  
  /// set text color
  void setTextColor(FXColor clr);

  /// set the text font
  void setFont(FXFont* f);

  /// get the text width of specified text
  FXint getTextWidth(const FXString& text);

  /// get the text height of specified text
  FXint getTextHeight(const FXString& text);

  /// get the current text width
  FXint getTextWidth();

  /// get the current text height
  FXint getTextHeight();

  /// get the font ascent
  FXint getFontAscent();
  
  /// dtor
  virtual ~FXSpriteObject();
};

#endif // FXSPRITEOBJECT_H

