/* Free Foundation Classes for XML ver.0.1.3
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcxml: ffcxml.h,v 1.8.3 2001/09/17 22:57:51 Toshihiro Inoue Exp $
 */

#ifndef _FFCXML_H_
#define _FFCXML_H_

#include <ffcdictstring.h>
#include <ffcstring.h>

#include <stdio.h>


class FFCXML
{
public:
  inline FFCString getName() const { return name; }
  inline FFCString getData() const { return data; }
  inline FFCString operator[](const FFCString& n) const { return attr[n]; }
  inline void setLetter(bool l) { letter = l; }
  
public:
  FFCXML();
  virtual ~FFCXML();
  void init();
  bool open(const FFCString& fn);
  void set(const FFCString& x);
  void set(const char* buf, int len);
  bool read();
  bool readChar(char& ch);
  static int parse(const FFCString& element, FFCString& name, FFCDictString& attr, bool letter = true);
  static FFCString toEntity(const FFCString& text);
  static FFCString fromEntity(const FFCString& text);
  
private:
  void __init_class__();
  
protected:
  FILE* file;
  FFCString xml;
  int pos;
  const char* ptr;
  FFCString name;
  FFCString data;
  FFCDictString attr;
  bool letter;
};

#endif // _FFCXML_H_
