/* Free Foundation Classes for list ver.0.1.2
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffclist: ffcdict.h,v 1.15.0 2001/09/17 22:57:49 Toshihiro Inoue Exp $
 */

#ifndef _FFCDICT_H_
#define _FFCDICT_H_

#include "ffclist.h"

#include <ffcstring.h>


class FFCDict
{
public:
  inline FFCString** getKey() const { return (FFCString**)key.data(); }
  inline void** getData() const { return data.data(); }
  inline int length() const { return key.length(); }
  inline bool empty() const { return key.length() < 1; }
  
public:
  FFCDict();
  FFCDict(const FFCDict& d);
  virtual ~FFCDict();
  void erase();
  FFCDict& operator=(const FFCDict& d);
  void setData(const FFCString& k, void* d);
  void* operator[](const FFCString& k) const;
  int keyPos(const FFCString& k) const;
  
private:
  void __init_class__();
  
protected:
  FFCList key;
  FFCList data;
};

#endif // _FFCDICT_H_
