/* Free Foundation Classes for list ver.0.1.2
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffclist: ffclist.h,v 1.60.0 2001/09/17 22:57:49 Toshihiro Inoue Exp $
 */

#ifndef _FFCLIST_H_
#define _FFCLIST_H_

typedef void(*DELETEFUNC)(void*&);
typedef void(*COPYFUNC)(void*&, void*);


class FFCList
{
public:
  inline operator void**() const { return buffer; }
  inline void** data() const { return buffer; }
  inline int length() const { return size; }
  inline void* operator[](int pos) const { return buffer[pos]; }
  inline bool empty() const { return size < 1; }
  inline void setDeleteFunc(DELETEFUNC f) { delFunc = f; }
  inline void setCopyFunc(COPYFUNC f) { copyFunc = f; }
  
public:
  FFCList();
  FFCList(const FFCList& l);
  FFCList(const FFCList& l, int pos, int len);
  FFCList(void** d, int len);
  virtual ~FFCList();
  void setMaxSize(int sz);
  void erase();
  FFCList& operator=(const FFCList& l);
  FFCList& setData(void** d, int len);
  void setData(int pos, void* d);
  FFCList& operator+=(void* d);
  FFCList& operator+=(const FFCList& l);
  FFCList operator+(const FFCList& l) const;
  FFCList mid(int pos, int len = -1) const;
  FFCList left(int len) const;
  FFCList right(int len) const;
  FFCList insert(int pos, const FFCList& l) const;
  FFCList remove(int pos, int len = -1) const;
  int find(void* d) const;
  int rfind(void* d) const;
  FFCList& operator-=(int len);
  FFCList& directInsert(int pos, void* d);
  FFCList& directInsert(int pos, const FFCList& l);
  FFCList& directRemove(int pos, int len = -1);
  void useString();
  static void delString(void*& p);
  static void copyString(void*& dst, void* src);
  void memcpy(void** dst, void** src, int len);
  
private:
  void __init_class__();
  void init();
  
protected:
  void** buffer;
  int size;
  int max;
  DELETEFUNC delFunc;
  COPYFUNC copyFunc;
};

#endif // _FFCLIST_H_
