/* Free Foundation Classes for thread ver.0.1.5
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcthread: ffccond.cpp,v 1.6.0 2001/09/17 22:57:46 Toshihiro Inoue Exp $
 */

#include "ffccond.h"




void FFCCond::__init_class__()
{
  flgSgn = false;
}


FFCCond::FFCCond(): FFCMutex()
{
  __init_class__();
  
  #ifdef WIN32
  cond = CreateEvent(NULL, FALSE, FALSE, NULL);
  #else
  pthread_cond_init(&cond, NULL);
  #endif
}


FFCCond::~FFCCond()
{
  #ifdef WIN32
  CloseHandle(cond);
  #else
  pthread_cond_destroy(&cond);
  #endif
}


void FFCCond::broadcast()
{
  if(flgSgn) return;
  
  #ifdef WIN32
  SetEvent(cond);
  #else
  pthread_cond_broadcast(&cond);
  #endif
  flgSgn = true;
}


void FFCCond::wait()
{
  #ifdef WIN32
  unlock();
  WaitForSingleObject(cond, INFINITE);
  lock();
  if(!flgSgn) ResetEvent(cond);
  #else
  pthread_cond_wait(&cond, &mutex);
  #endif
  flgSgn = false;
}
