/* Free Foundation Classes for thread ver.0.1.5
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcthread: ffcthread.h,v 1.33.0 2001/09/17 22:57:46 Toshihiro Inoue Exp $
 */

#ifndef _FFCTHREAD_H_
#define _FFCTHREAD_H_

#include "ffcmutex.h"
#include "ffccond.h"

class FFCThread;

#ifdef WIN32
#  define THREAD_T HANDLE
#else
#  define THREAD_T pthread_t
#endif

typedef struct {
  FFCThread* owner;
  THREAD_T thread;
  FFCMutex mutex;
} FFCThreadInternal;

#define CHECK_STOP(ti) if(ti != internal) return


class FFCThread
{
public:
  inline bool isEnabled() const { return internal != NULL; }
  
public:
  FFCThread();
  virtual ~FFCThread();
  virtual void create();
  virtual bool cancel();
  virtual void exec(FFCThreadInternal* ti);
  virtual void begin(FFCThreadInternal* ti);
  virtual void end(FFCThreadInternal* ti);
  
private:
  void __init_class__();
  
protected:
  FFCThreadInternal* internal;
};

#endif // _FFCTHREAD_H_
