#include "FXVTable.h"


class TableWindow : public FXMainWindow {
  FXDECLARE(TableWindow)
protected:

  // Member data
  FXVerticalFrame*   frame;
  FXVTable*          table;

protected:
  TableWindow();

public:
  enum{
    ID_TEST=FXMainWindow::ID_LAST,
    ID_LAST
    };

public:

  TableWindow(FXApp* a);
  virtual void create();
  virtual ~TableWindow() {}; 

  long onCmdTest(FXObject*,FXSelector,void*);
};

TableWindow::TableWindow(){
};


class MyDataSource : public FXVTableSource {
   char* tableData[100][100];
public:
  MyDataSource();
  ~MyDataSource();
  FXint getRows() { return 800; };
  FXint getCols() { return 40; };

  virtual FXbool verifyCell(const FXVTableCellPos& cell) { return TRUE; };
  virtual FXbool addRequest(const FXVTableCellPos& cell) { return TRUE; };
  virtual FXbool delRequest(const FXVTableCellPos& cell) { return TRUE; };

  virtual void add(const FXVTableCellPos& cell) {};
  virtual void del(const FXVTableCellPos& cell) {};
  
  virtual FXString getData(const FXVTableCellPos& cell);
  virtual FXbool setData(const FXVTableCellPos& cell, const FXString& d);
};

MyDataSource::MyDataSource() { 
  memset(tableData,0,sizeof(tableData)); 
};
MyDataSource::~MyDataSource() { 
  char *c=tableData[0][0];
  while(c<=tableData[99][99]){
    if(c)
      free(c);
    c++;  
  };
}; 
FXString MyDataSource::getData(const FXVTableCellPos& cell){
    char buff[10];
    if(cell.row<100 && cell.col<100 && !cell.rowSw && !cell.colSw && tableData[cell.row][cell.col])
      return FXString(tableData[cell.row][cell.col]);
#ifdef WIN32
    _snprintf(buff,sizeof(buff),"%d:%d %d:%d",cell.row,cell.col,cell.rowSw,cell.colSw);
#else
    snprintf(buff,sizeof(buff),"%d:%d %d:%d",cell.row,cell.col,cell.rowSw,cell.colSw);
#endif
    if(cell.row<100 && cell.col<100 && !cell.rowSw && !cell.colSw)
      tableData[cell.row][cell.col]=strdup(buff);
    return FXString(buff);
};

FXbool MyDataSource::setData(const FXVTableCellPos& cell, const FXString& d){
    if(cell.row<100 && cell.col<100 && !cell.rowSw && !cell.colSw){
      if(tableData[cell.row][cell.col])
        free(tableData[cell.row][cell.col]);
      tableData[cell.row][cell.col]=strdup(d.text());
    };  
    return TRUE;
};

/*******************************************************************************/

// Map
FXDEFMAP(TableWindow) TableWindowMap[]={
  FXMAPFUNC(SEL_COMMAND,TableWindow::ID_TEST,TableWindow::onCmdTest),
};

// Object implementation
FXIMPLEMENT(TableWindow,FXMainWindow,TableWindowMap,ARRAYNUMBER(TableWindowMap))

TableWindow::TableWindow(FXApp* a) : FXMainWindow(a,"Table Widget Test",NULL,NULL,DECOR_ALL,0,0,400,200) {
  frame=new FXVerticalFrame(this,LAYOUT_SIDE_TOP|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);
  table=new FXVTable(frame,new MyDataSource(),this,ID_TEST,TABLE_COL_SIZABLE|TABLE_ROW_SIZABLE|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0);
  new FXButton(frame,"Button1",NULL,this,ID_TEST);
  new FXButton(frame,"Button2",NULL,this,ID_TEST);
  table->allocLeadingRow();
  table->allocTrailingRow();
  table->allocLeadingCol();
  table->allocTrailingCol();

  table->joinCells(FXVTableCellPos(2,2,0,0),2,2);

  FXVTableStyle s=table->getCellStyle(FXVTableCellPos(1,1,0,0));
  s.cellType=1;

  table->setCellStyle(FXVTableCellPos(1,1,0,0),s);
//  table->setCellStyle(FXVTableCellPos(1,3,0,0),s);
//  table->setCellStyle(FXVTableCellPos(3,1,0,0),s);
//  table->setCellStyle(FXVTableCellPos(5,2,0,0),s);

//  s=table->getCellStyle(FXVTableCellPos(0,0,0,0));
//  s.row=-1;
//  s.colWidth=50;
//  table->setCellStyle(FXVTableCellPos(-1,0,0,0),s);

};


void TableWindow::create(){
  FXMainWindow::create();
  show(PLACEMENT_SCREEN);
  }

long TableWindow::onCmdTest(FXObject*,FXSelector,void*) { return 1; };


// Start the whole thing
int main(int argc,char *argv[]){

  // Make application
  FXApp application("TableApp","FoxTest");

  // Open display
  application.init(argc,argv);

  // Make window
  new TableWindow(&application);

  // Create app
  application.create();

  // Run
  return application.run();
}
